/* 

   This is an implementation of the hypernetwork architecture
   learning algorithm
   June/July 2004.
   (c) Jose L. Segovia-Juarez, 1999-2004.
  
   Input: - parameters file in the specified format
          - training data file  
	  - No. of epochs to iterate
	  - File to store training data	  
	  - Adding populations 
*/


#include "filemag04.h"  
#include "simfunc04.h"  
#include "constants.h"
#include "cran32.h"  
#include <math.h>  
#include <time.h>  
#include <fstream>
#include <iomanip>

double MIN_ERROR = 0.001;
double EPSILON = 0.000001;
using namespace std;

int main(int argc, char* argv[])    
{  

  time_t initime, fintime; 
  struct tm * timeinfo1;
  struct tm * timeinfo2;
  initime = time(NULL);
  timeinfo1 = localtime (  &initime );
  string mytime1 = asctime(timeinfo1);
  string mytime2;

  const int maxcolsaveres = 10;  
  double (*saveres)[maxcolsaveres];   
	
  // pointers to data vectors   
  a_s *input_v;  
  a_s *output_v;  
  a_s *desired_v;  
  double *error_v; 
  array_aux *a_org;
  moltmp *molist;
	
  char fileres[512];
  string myword;
  organism org, org_best;
  int termina_c = 0;  
  int i,ii,ll, cc;   
  int npop = 50;
  int MAXPOP = 2000;
  double epop[MAXPOP]; // error of population
  char nametmp[1024];	
  global_data gd;  

  CRan32 rnd(initime,time(NULL)+999);  
  if ((argc < 6 ) || (argc > 7)) 
    error("Input: parameter_file input_file #epochs result_file #population [Optional plotting: 1 =display learning, 2 =Plot organism]");  
	
  gd.actual_iter = 1;  
  gd.n_iter = (int)strtol(argv[3],(char **) NULL,10);  
  if (gd.n_iter <= 0) error("Number of iterations should be > 0");  
  // read_global variables   

  read_parameters_file(argv[1], org, gd, rnd);  
  a_org = new array_aux[gd.total_number_of_molecules+1]; // start in 1
	
  const short length_result_array = 100;  
  saveres = new double[length_result_array][maxcolsaveres];   
  ifstream input_file(argv[2]);
  if (!input_file) error("Cannot find input vector file");
  input_file >> cc;
  input_file.close();
  if (cc <= 0) error("Number of input vectors should be greather than zero ");
  gd.n_input_v = cc;
  
  ofstream fileResults;
  fileResults.open(argv[4]);
  if (!fileResults) error("Error opening results file");
  
  npop =  (int)strtol(argv[5],(char **) NULL,10); 
  if (npop > MAXPOP) error("Population should be <= ", MAXPOP);
  if (npop < 2) error("Population should be >= 2");
  if (gd.shape_size > max_molecule_domain) error("Molecule domain too long. Increase max_molecule_domain constant."); 
  /*
  strcpy(nametmp, "mkdir ");
  strcat(nametmp, argv[1]);
  strcat(nametmp, "_tmp");
  system(nametmp);
  */
  //  system("rm -rf tmp/*");
  gd.lookat = 0;
  if (argc == 7) 
    gd.lookat = (int)strtol(argv[6],(char **) NULL,10);  
  if ((gd.lookat > 2) || (gd.lookat < 0)) error("Optional plotting parameter should be 0, 1 or 2.");

  input_v = new a_s[cc+1];  
  desired_v = new a_s[cc+1]; 
  read_input_file(argv[2], input_v, desired_v, gd);  
  output_v = new a_s[gd.n_input_v+1];  
  error_v =  new double[gd.n_input_v+1];
  molist = new moltmp[npop*gd.total_number_of_molecules];

  gd.g_error = 0.0;  
  gd.g_error_step = 0.0;
  gd.c_time = 0;  
  gd.n_try = 1;   
  int p;
  warming_up_random(rnd);   
  update_cells_num(INPUT, INPUT, org,gd);
  update_cells_num(INPUT_OUTPUT, INPUT, org,gd);
  set_readout_molecules_random(org, rnd);     
  set_inhibitor_molecules(org, gd, rnd);  
  
  create_copy_organism(org_best, org); 
  gd.g_error_step = gd.g_error;
  
  if (gd.lookat == 2)
     cout << "Press Ctrl-Break to end the simulation or Continue. " << endl; 
  int nmolchanged;
  i = gd.actual_iter;  
  ii = 0;  
  double currentbest =0.0;
  int pointobest = 0;
  int counterbest = 0;
  int randomselect = 0;
  int nmolp, totalncells, totalnmol, ncell, ncurrmol;
  if (gd.lookat == 1)
    cout << "#Epoch \t [Population performance] \t -> [best performer] " << endl; 

  while ((i <= gd.n_iter) && (!termina_c))  
    { 
      gd.actual_iter = i;  
      // copy current best on place 0
      just_copy_organism(org,org_best);
      //save_organism_file_pop(argv, org_best, gd, 0); // at the beginning
		totalncells = org.ncells;
		ncurrmol = 0;
		for (ncell = 1; ncell <= totalncells; ncell++)
		  {
			 totalnmol = org.ocells[ncell].cell_n_molec;
			 for(nmolp=1; nmolp <= totalnmol; nmolp++)
				{
				  strcpy(molist[ncurrmol].mol_shape,    org_best.ocells[ncell].mols[nmolp].mol_shape.c_str());
				  strcpy(molist[ncurrmol].r_activation, org_best.ocells[ncell].mols[nmolp].r_activation.c_str());
				  strcpy(molist[ncurrmol].r_inhibition, org_best.ocells[ncell].mols[nmolp].r_inhibition.c_str());
				  ncurrmol++;
				}
		  }
      // for each organismn
      for (p=1; p < npop; p++)
		  {
			 do 
				{
				  nmolchanged = change_mol_structure_prob(org_best, gd, rnd);	      
				} 
			 while (nmolchanged == 0); 
			 update_cells_num(INPUT, INPUT, org_best,gd);
			 update_cells_num(INPUT_OUTPUT, INPUT, org_best,gd);
			 // save_organism_file_pop(argv, org_best, gd, p);
			 // cout << "p= " << p << endl;
			 ncurrmol = p*gd.total_number_of_molecules;
			 for (ncell = 1; ncell <= totalncells; ncell++)
				{
				  totalnmol = org.ocells[ncell].cell_n_molec;
				  for(nmolp=1; nmolp <= totalnmol; nmolp++)
					 {
						strcpy(molist[ncurrmol].mol_shape,    org_best.ocells[ncell].mols[nmolp].mol_shape.c_str());
						strcpy(molist[ncurrmol].r_activation, org_best.ocells[ncell].mols[nmolp].r_activation.c_str());
						strcpy(molist[ncurrmol].r_inhibition, org_best.ocells[ncell].mols[nmolp].r_inhibition.c_str());
						//	cout << "nmolp = " << nmolp << "-" << ncurrmol << endl;
						ncurrmol++;
					 }
				}
			 just_copy_organism(org_best,org);
		  }
  
		// for each saved organism 
		// read from the disk
		// for each organismn
       if (gd.lookat == 1) 
			cout << setprecision(2) << i << "\t";
		 for (p=0; p< npop; p++)
			{
			  //read_organism_file_pop(argv, org_best, gd,p);
			  ncurrmol =  p*gd.total_number_of_molecules;
			  for (ncell = 1; ncell <= totalncells; ncell++)
				{
				  totalnmol = org.ocells[ncell].cell_n_molec;
				  for(nmolp=1; nmolp <= totalnmol; nmolp++)
					 {
					   org_best.ocells[ncell].mols[nmolp].mol_shape = 	molist[ncurrmol].mol_shape;
						org_best.ocells[ncell].mols[nmolp].r_activation = molist[ncurrmol].r_activation;
						org_best.ocells[ncell].mols[nmolp].r_inhibition = molist[ncurrmol].r_inhibition;
						ncurrmol ++;
					 }
				}
			  fill_relation_array(org_best, gd, a_org);  
			  set_molecules_initial(org_best, a_org); 	  
			  set_counters_initial(org_best); 
			  epop[p]  = epoch_pop(org_best, gd, input_v, output_v, desired_v, rnd, a_org, TRAIN);
			  if (gd.lookat == 1)
				 cout << setw(2) << epop[p] << "\t";
			}
      // find the best and this is the best one
      
		 currentbest = 0.0;
		 counterbest = 0;
		 for (p=0; p < npop; p++)
			if (currentbest <= epop[p])
			  {  pointobest = p;	 currentbest = epop[p]; }
		 
		 if (gd.lookat == 1)
			cout << "->" << pointobest << "\t" << epop[pointobest] << endl;
		 gd.g_error_step = epop[pointobest];
       //read_organism_file_pop(argv, org_best, gd, pointobest);
		 ncurrmol = pointobest*gd.total_number_of_molecules;
		 for (ncell = 1; ncell <= totalncells; ncell++)
				{
				  totalnmol = org.ocells[ncell].cell_n_molec;
				  for(nmolp=1; nmolp <= totalnmol; nmolp++)
					 {
					   org_best.ocells[ncell].mols[nmolp].mol_shape = 	molist[ncurrmol].mol_shape;
					    org_best.ocells[ncell].mols[nmolp].r_activation = molist[ncurrmol].r_activation;
					    org_best.ocells[ncell].mols[nmolp].r_inhibition = molist[ncurrmol].r_inhibition;
					    ncurrmol++;
					 }
				}
       save_organism_file(argv, org_best, gd);
       gd.g_error = gd.g_error_step;
       saveres[ii][0] = i;  
       saveres[ii][1] = gd.g_error_step;

       i++;  
      ii++;  
      if (ii >= length_result_array)  
	{   
	  for (ll=0; ll<ii; ll++)  
	    fileResults << saveres[ll][0] << "\t" << saveres[ll][1] << endl;
	  //    "\t" <<  saveres[ll][2] << "\t"<< saveres[ll][3] << "\t" << saveres[ll][4] <<  "\t" <<  saveres[ll][5] << endl;
	  ii = 0 ;   
	}				
      if ((1.0 - gd.g_error) < gd.minimal_global_error)  // epsilon  
	{   
	  cerr << "\t -- OK! " << endl;  
	  termina_c = TRUE;  
	} 
    }

  save_organism_file(argv, org_best, gd);
  for (ll=0; ll<ii; ll++)  
    fileResults << saveres[ll][0] << "\t" << saveres[ll][1] <<  endl; //"\t" << saveres[ll][2] <<
  //"\t" <<  saveres[ll][3] << "\t" << saveres[ll][4] << "\t" <<  saveres[ll][5] << endl;
 
  delete [] input_v;  
  delete [] output_v;  
  delete [] desired_v;  
  delete [] error_v;  
  delete [] saveres;      
  delete [] molist;
  fintime = time(NULL);
  timeinfo2 = localtime (&fintime);
  mytime2 = asctime(timeinfo2);
  int ntime, nhour, nmin, nsec;  
  ntime = (int)difftime(fintime,initime);  
  nhour = ntime / 3600;  
  ntime = ntime % 3600;  
  nmin = ntime / 60;  
  ntime = ntime % 60;  
  nsec = ntime;  
  fileResults << "## No. organisms: " << npop << endl;
  fileResults << "## Seeds        : " << gd.seed1 << ", " << gd.seed2 << endl;
  fileResults << "## Runtime      : " << nhour << "h " << nmin << "m " << nsec << "s." << endl;     
  fileResults << "## Started at   : " << mytime1;
  fileResults << "## Ended at     : " << mytime2;  
  fileResults.close();
  if (gd.lookat == 1)
    {cout << "## Runtime  : " << nhour << "h " << nmin << "m " << nsec << "s." << endl; 
		// cout << "## END-OF-RUN" <<endl; 
	 }
  delete_organism(org);    
  delete_organism(org_best);
   return 0;     
}  



