/* 

   This is an implementation of the hypernetwork architecture. 
   June/July 2004.
   (c) Jose L. Segovia-Juarez, 1999-2004.
  
   Input: - parameters file in the specified format
          - training data file  
	  - No. of epochs to iterate
	  - File to store training data
   
*/


#include "filemag04.h"  
#include "simfunc04.h"  
#include "constants.h"
#include "cran32.h"  
#include <math.h>  
#include <time.h>  
#include <fstream>
double MIN_ERROR = 0.001;
double EPSILON = 0.000001;
using namespace std;

unsigned _stklen = 1048576;

int main(int argc, char* argv[])   
{  

  time_t initime, fintime; 
  struct tm * timeinfo1;
  struct tm * timeinfo2;
  initime = time(NULL);
  timeinfo1 = localtime (  &initime );
  string mytime1 = asctime(timeinfo1);
  string mytime2;

  const int maxcolsaveres = 10;  
  double (*saveres)[maxcolsaveres];   
	
  // pointers to data vectors   
  a_s *input_v;  
  a_s *output_v;  
  a_s *desired_v;  
  double *error_v; 
  array_aux *a_org;
	
  char fileres[512];
 
  organism org, org_best;
  int termina_c = 0;  
  int i,ii,ll, cc;   
	
  global_data gd;  

  CRan32 rnd(initime,time(NULL)+999);  
  if ((argc < 5 ) || (argc > 6)) 
    error("Input: parameter_file input_file #epochs result_file [Optional plotting: 1 =display learning, 2 =Plot organism]");  
	
  gd.actual_iter = 1;  
  gd.n_iter = (int)strtol(argv[3],(char **) NULL,10);  
  if (gd.n_iter <= 0) error("Number of iterations should be > 0");  
  // read_global variables   


  read_parameters_file(argv[1], org, gd, rnd);  
  a_org = new array_aux[gd.total_number_of_molecules+1]; // start in 1
	
  const short length_result_array = 100;  
  saveres = new double[length_result_array][maxcolsaveres];   
  ifstream input_file(argv[2]);
  if (!input_file) error("Cannot find input vector file");
  input_file >> cc;
  input_file.close();
  if (cc <= 0) error("Number of input vectors should be greather than zero ");
  gd.n_input_v = cc;
  
  ofstream fileResults;
  fileResults.open(argv[4]);
  if (!fileResults) error("Error opening results file");

  gd.lookat = 0;
  if (argc == 6) 
    gd.lookat = (int)strtol(argv[5],(char **) NULL,10);  
  if ((gd.lookat > 2) || (gd.lookat < 0)) error("Optional plotting parameter should be 0, 1 or 2.");

  input_v = new a_s[cc+1];  
  desired_v = new a_s[cc+1]; 
  read_input_file(argv[2], input_v, desired_v, gd);  
  output_v = new a_s[gd.n_input_v+1];  
  error_v =  new double[gd.n_input_v+1];
  gd.g_error = 0.0;  
  gd.g_error_step = 0.0;
  gd.c_time = 0;  
  gd.n_try = 1;   
  
  warming_up_random(rnd);   
  update_cells_num(INPUT, INPUT, org,gd);
  update_cells_num(INPUT_OUTPUT, INPUT, org,gd);
  set_readout_molecules_random(org, rnd);     
  set_inhibitor_molecules(org, gd, rnd);  
  
  create_copy_organism(org_best, org); 
  gd.g_error_step = gd.g_error;
  
  if (gd.lookat == 2)
     cout << "Press Ctrl-Break to end the simulation or Continue. " << endl; 

  i = gd.actual_iter;  
  ii = 0;  
  if (gd.lookat == 1)
    cout << "# Epoch \t Current \t Best  \t No. Molecules mutated " << endl; 

  while ((i <= gd.n_iter) && (!termina_c))  
    { 
      gd.actual_iter = i;  
      set_counters_initial(org_best); 
      gd.g_error_step  = epoch(org_best, gd, input_v, output_v, desired_v, rnd, a_org, TRAIN);  
      if (gd.lookat == 1)
	cout << i << "\t" << gd.g_error_step << "\t"<< gd.g_error  << "\t" << gd.counter_mutated_molecules <<  endl;
      if (gd.g_error_step >= gd.g_error) 
	{
	  gd.g_error = gd.g_error_step;	  
	  just_copy_organism(org,org_best);
	  save_organism_file(argv,org, gd);
	}
      else
	{
	  
	  just_copy_organism(org_best,org);
	  
	}
      saveres[ii][0] = i;  
      saveres[ii][1] = gd.g_error_step;
      saveres[ii][2] = gd.g_error; 
      saveres[ii][3] = gd.mutation_rate_mol_cell;	
      saveres[ii][4] = gd.threshold_activation;
      saveres[ii][5] = gd.counter_mutated_molecules;  
      i++;  
      ii++;  
      if (ii >= length_result_array)  
	{   
	  for (ll=0; ll<ii; ll++)  
	    fileResults << saveres[ll][0] << "\t" << saveres[ll][1] << "\t" <<  saveres[ll][2] 
			<< "\t"<< saveres[ll][3] << "\t" << saveres[ll][4] <<  "\t" <<  saveres[ll][5] << endl;
	  ii = 0 ;   
	}				
      if ((1.0 - gd.g_error) < gd.minimal_global_error)  // epsilon  
	{   
	  cerr << " OK! " << endl;  
	  termina_c = TRUE;  
	}  
    }
  //  print_data_org(org); 
  save_organism_file(argv, org, gd);
  for (ll=0; ll<ii; ll++)  
    fileResults << saveres[ll][0] << "\t" << saveres[ll][1] << "\t" << saveres[ll][2] <<
      "\t" <<  saveres[ll][3] << "\t" << saveres[ll][4] << "\t" <<  saveres[ll][5] << endl;
 
  delete [] input_v;  
  delete [] output_v;  
  delete [] desired_v;  
  delete [] error_v;  
  delete [] saveres;      
  fintime = time(NULL);
  timeinfo2 = localtime (&fintime);
  mytime2 = asctime(timeinfo2);
  int ntime, nhour, nmin, nsec;  
  ntime = (int)difftime(fintime,initime);  
  nhour = ntime / 3600;  
  ntime = ntime % 3600;  
  nmin = ntime / 60;  
  ntime = ntime % 60;  
  nsec = ntime;  
  fileResults << "## Seeds    : " << gd.seed1 << ", " << gd.seed2 << endl;
  fileResults << "## Runtime  : " << nhour << "h " << nmin << "m " << nsec << "s." << endl;     
  fileResults << "## Begins at: " << mytime1;
  fileResults << "## Ends   at: " << mytime2;  
  fileResults.close();
  if (gd.lookat == 1)
    {cout << "## Runtime  : " << nhour << "h " << nmin << "m " << nsec << "s." << endl; 
    //  cout << "## END-OF-RUN" <<endl; 
    }
  delete_organism(org);    
  delete_organism(org_best);
   return 0;     
}  



