#include <vector>
#include <time.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <string>
#include <iostream>
#include <fstream>

#include "filemag04.h"
#include "misc.h"

using namespace std;

/* 

   This is an implementation of the hypernetwork architecture
   learning algorithm
   June/July 2004.
   (c) Jose L. Segovia-Juarez, 1999-2004.
	
   File management functions.

*/

void read_parameters_file(char argv[], organism &org, global_data &gdata, CRan32 &myrandom)
{   
  char name1[3000];
  string name, topol, type;
  char mytime[32];
  int d1,d2,d3, ncell,  x, y, nreadout; //, z; 
  float fd1; long rd1, rd2;
  float muta1, muta2;
  rd1 = 1;
  rd2 = 2;
  muta1 = 0.0;
  muta2 = 0.0;
  int i,j,k; //iterators
  gdata.mutation_rate_mol_cell = 1;
  gdata.mutation_rate_atom_mol = 1; // default
  nreadout = 2;
  int notermina = TRUE;
  ifstream file(argv,ios::in);
  if (file.is_open()==0) error("Parameters file not found!");  
  // cout << "Reading parameter file, creating organism " << endl;
  while(!file.eof())  
    {
      file >> name ;
      if (name  == "molecular_shape_size")
	{
	  file >> d1; gdata.shape_size = d1; 
	  continue;
	}	
      if (name  == "create_organism")
	{ 			 
	  file >> d1; gdata.number_of_cells = d1;  // number of cells 
	  org.ncells = d1; 
	  if (d1  > max_n_cell_org ) error(" Excesive number of cells !"); 		    
	  if (d1 <= 0) error("Number of cells should be > 0");
	  org.ocells = new cell[d1+1];
	  continue;
	}
      if (name  == "create_cell")
	{ 
	  d1 = 0; x = 0; y = 0; ncell = 0;
	  if (!file.eof()) 
	    file >> ncell; 
	  if (!file.eof()) 
	    file >> d1; 
	  if (!file.eof()) 
	    file >> topol; 
	  if (!file.eof()) 
	    file >> x; 
	  if (!file.eof()) 
	    file >> y; 
	  if (!file.eof()) 
	    file >> type; 
	  if (!file.eof()) 
	    file >> nreadout; 
	  if ((x <= 0) || (y <= 0) || (ncell <= 0) || (d1 <= 0) )
	    error(" Expecting a number, wrong topology, or number of molecules to create the cell ", ncell);
	  if (d1 != (x * y)) error("Wrong topology, Number of molecules !=  X * Y in cell", ncell);

	  if (nreadout < 0) error("Incorrect number of readouts for cell. Readouts should be > 0 in cell ", ncell);

	  cell *newcell; 
	  newcell = new cell;
	  newcell->mols = new molecule[d1+1];
	  newcell->cell_id = ncell;
	  newcell->cell_n_molec = d1;
	  newcell->x = x;  // ROWS
	  newcell->y = y;  // COLS
	  newcell->cell_n_readout = nreadout;
	  if (topol == "rect")  newcell->topology = topology_rectangle;
	  else
	    error("Wrong cell topology at create cell ", ncell);
	  if (type == "input")  newcell->cell_type = INPUT;
	  else
	    if (type == "input_output") newcell->cell_type = INPUT_OUTPUT; 
	    else
	      if (type == "internal1") newcell->cell_type = METAB1; 
	      else 
		if (type == "internal2") newcell->cell_type = METAB2;
		else
		  if (type == "output")  newcell->cell_type = OUTPUT;
		  else
		    error("Wrong cell type at cell ", ncell);			 
	  org.ocells[ncell] = *newcell;
	  continue;
	}

      if (name == "n_receptors_cell")
	{
	  d1 = 0; d2 = 0;
	  if (!file.eof()) 
	    file >> d1; 
	  if (!file.eof()) 
	    file >> d2;  
	  if (d2 <= 0) error("Number of receptors should be > 0 at cell ", ncell);
	  org.ocells[d1].cell_n_r_mol = d2;
	  continue;
	}
      if (name == "n_effectors_cell")
	{ 
	  d1 = 0; d2 = 0;
	  if (!file.eof()) 
	    file >> d1; 
	  if (!file.eof()) 
	    file >> d2;  
	  if (d2 <= 0) error("Number of effectors should be > 0 in cell ", ncell);
	  org.ocells[d1].cell_n_e_mol = d2;
	  continue;
	}
      if (name == "n_internal_cell")
	{ 
	  d1 = 0; d2 = 0;
	  if (!file.eof()) 
	    file >> d1; 
	  if (!file.eof()) 
	    file >> d2;  
	  if (d2 <= 0) error("Number of internal molecules should be > 0 in cell ", ncell);
	  org.ocells[d1].cell_n_i_mol = d2;
	  continue;
	}      
      if (name == "p_inhibitors_cell") 
	{
	  d1 = 0; d2 = 0;
	  if (!file.eof()) 
	    file >> d1; 
	  if (!file.eof())  
	    file >> d2;
	  if  (d1 <= 0)  error("Number of cell should be > 0 ");
	  if  (d2 < 0)   error("p_inhibitors parameters should be >= 0 ");
	  // if  (d2 == 0)  warning("p_inhibitors in cell is  == 0 ");
	  org.ocells[d1].p_inhibitors = d2;
	  continue;
	}
      if (name == "copy_structure_cell") 
	{ 
	  d1 = 0; d2 = 0;
	  if (!file.eof()) 
	    file >> d1;
	  if (!file.eof()) 
	    file >> d2;
	  if ( (d1 <= 0) || (d2 <= 0) ) error("copy: number of cell error ");
	  // copy d1 into d2 only if they have the same number of molecules
	  if (org.ocells[d1].cell_n_molec != org.ocells[d2].cell_n_molec)
	    error("copy_structure_cell not possible, number of molecules of cells are different -cell No.", d2);
	   if (org.ocells[d1].x != org.ocells[d2].x)
	       error("copy_structure_cell not possible, topology on x are different -cell No.", d2);
	    if (org.ocells[d1].y != org.ocells[d2].y)
	       error("copy_structure_cell not possible, topology on y are different -cell No.", d2);
	  org.ocells[d2].cell_n_i_mol = org.ocells[d1].cell_n_i_mol;
	  org.ocells[d2].cell_n_r_mol = org.ocells[d1].cell_n_r_mol;
	  org.ocells[d2].cell_n_e_mol = org.ocells[d1].cell_n_e_mol;
	  org.ocells[d2].p_inhibitors =  org.ocells[d1].p_inhibitors;
	  org.ocells[d2].cell_n_readout = org.ocells[d1].cell_n_readout;
	  // more?
	  continue;
	}
      if (name == "copy_structure_cell_range") 
	{ 
	  d1 = 0; d2 = 0; d3 = 0;
	  if (!file.eof()) file >> d1; 
	  if (!file.eof()) file >> d2 ; 
	  if (!file.eof()) file >> d3;
	  if ( (d1 <= 0) || (d2 <= 0) || (d3 <=3) ) error("copy_range: number of cell error at ", ncell);
	  // copy d1 into d2
	  for(k=d2; k<=d3; k++)

	    { 
	      if (org.ocells[k].cell_n_molec != org.ocells[d1].cell_n_molec)
		error("copy_structure_cell not possible, number of molecules of cells are different -cell No. ", k);
	       if (org.ocells[k].x != org.ocells[d1].x)
	       error("copy_structure_cell not possible, topology on x are different -cell No.", d2);
	    if (org.ocells[k].y != org.ocells[d1].y)
	       error("copy_structure_cell not possible, topology on y are different -cell No.", d2);
	      org.ocells[k].cell_n_i_mol = org.ocells[d1].cell_n_i_mol;
	      org.ocells[k].cell_n_r_mol = org.ocells[d1].cell_n_r_mol;
	      org.ocells[k].cell_n_e_mol = org.ocells[d1].cell_n_e_mol;
	      org.ocells[k].p_inhibitors =  org.ocells[d1].p_inhibitors;
	      org.ocells[k].cell_n_readout = org.ocells[d1].cell_n_readout;
	      org.ocells[k].readout = org.ocells[d1].readout;
	    }
	  continue;
	}

      if (name == "cell_cell")
	{ 
	  d1 = 0; d2 =0;
	  if (!file.eof()) file >> d1; 
	  if (!file.eof()) file >> d2; 
	  if ( (d1 <= 0) || (d2 <= 0) ) error("cell_cell: number of cell error at", ncell);
	  if (d1 > org.ncells) error ("Cell not found, cell_cell command at cell ", ncell);
	  if (d2 > org.ncells) error ("Cell not found, cell_cell command at cell ", ncell);
	  org.ocells[d1].interaction_cell.push_back(d2);
	  continue;
	}


      if (name == "cell_cell_copydest_range") 
	{
	  d1 = 0; d2 = 0; ncell = 0; 
	  if (!file.eof())  file >> ncell; 
	  if (!file.eof())   file >> d1; 
	  if (!file.eof())  file >> d2;
	  if ((ncell <=0) || (d1 <= 0) || (d2 <= 0)) error("copy cell_cell range error");
	  // for every member of the ncell in cell_cell.	
	   if (d1 > org.ncells) error ("Cell not found, cell_cell command at cell ", ncell);
	   if (d2 > org.ncells) error ("Cell not found, cell_cell command at cell ", ncell);
	  int jjj=0;
	  for(jjj=d1; jjj<=d2; jjj++)
	    {
	      org.ocells[ncell].interaction_cell.push_back(jjj);
	      // cout << "c _ c" << ncell << " - " << jjj << endl;
	    }
	  continue;
	}	

      if (name == "fraction_input_vector") 
	{
	  d1 = 0; d2 = 0;
	  if (!file.eof())   file >> d1;
	  if ( d1 <= 0) error("fraction input should be > 0");
	  gdata.fraction_input_vector = d1;
	  continue;
	}

      if (name == "threshold_activation")
	{
	  d1 = 0; d2 = 0;
	  if (!file.eof())  file >> d1;
	  if ( d1 == 0) warning("Threshold activation == 0");
	  if ( d1 < 0) error("threshold activation should be >= 0");
	  gdata.threshold_activation = d1;
	  continue;
	}
      if (name == "threshold_inhibition") 
	{
	  if (!file.eof())  file >> d1;
	  if (d1 == 0) warning ("Threshold inhibiton == 0");
	  if (d1 < 0) error("threshold inhibition should be >= 0");
	  gdata.threshold_inhibition = d1;
	  continue;
	}

      if (name == "minimal_global_error")
	{
	  d1 = 0; d2 = 0;
	  if (!file.eof())  file >> fd1;
	  if ( fd1 <= 0) error("minimal error should be > 0");
	  gdata.minimal_global_error = fd1;
	  continue;
	}
      if (name == "seeds") 
	{
	  if (!file.eof())  file >> mytime;
	  if ((strncmp(mytime,"CLOCK",5)==0) || (strncmp(mytime, "clock",5)==0))
	    {  
	      rd1 = time(NULL)-96330000;
	      if (!file.eof())  file >> mytime;
	      if ((strncmp(mytime,"CLOCK",5)==0) || (strncmp(mytime, "clock",5)==0))
		{						 
		  rd2 = rd1+9133;
		  myrandom.Reset(rd1,rd2);
		  rd2 = myrandom.Next(1,99999);
		}
	      else
		rd2 = atol(mytime);
	      if (rd2 <= 0)
		rd2 = rd1+9133;			  
	      myrandom.Reset(rd1,rd2);				  
	      // cout << "reset with internal clock  ->" << rd1  << ", " << rd2 << endl;
	    }
	  else 
	    { 
	      rd1 = atol(mytime); // seed and seed should be together!!!
	      if (!file.eof())  file >> mytime;
	      if ((strncmp(mytime,"CLOCK",5)==0) || (strncmp(mytime, "clock",5)==0))
		{						 
		  rd2 = time(NULL) - 963300000 ;
		}
	      else	 
		rd2 = atol(mytime); 
	      if (rd2 <= 0)
		rd2 = rd1+9133;				  
	      myrandom.Reset(rd1,rd2);	
	      // cout << mytime <<"- Reset with -> " << rd1  << endl; 
	    }
	  gdata.seed1 = rd1;
	  gdata.seed2 = rd2;
	  //cout << "#Seeds " << rd1 << ", " << rd2 << endl;
	  continue;
	}
		
      if (name == "mutation_rate_mol_cell") 
	{
	  muta1 =-1;
	  if (!file.eof())   file >> muta1;
	  if ((muta1 <= 0) || (muta1 > 100)) error(" mutation_rate_mol_cel should should be between 1 - 100.");
	  gdata.mutation_rate_mol_cell = muta1;
	  // cout << "muta = " << gdata.mutation_rate_mol_cell << endl; 
	  continue;
	}
      if (name == "mutation_rate_atom_mol") 
	{
	  muta2 = -1;
	  if (!file.eof())  file >> muta2;
	  if ((muta2 <= 0) || (muta2 > 100))  error(" mutation_rate_atom_mol should be 1 - 100."); 
	  gdata.mutation_rate_atom_mol = muta2;
	  continue;
	}
      if (name == "end.") {break; }
      if (name == "end")  {break; }
      if ((name == "//") || (name.substr(0,2) == "//"))  
	{ 
	  file.getline(name1,2000);
	  //cout << "#: " << name1 << endl;
	  continue; }      
      error("Incorrect token in parameter file. Token unknown: ", name);
    } 
  file.close();
  // assign location for the cells
  // counting the number of rows
  int row1, row2, row3, row4;
  row1 = row2 = row3 = row4 = 0;
  for(i=1; i<= gdata.number_of_cells; i++)
    {		
      org.ocells[i].threshold_activation = gdata.threshold_activation;
      org.ocells[i].threshold_inhibition = gdata.threshold_inhibition;
      org.ocells[i].loc_x = org.ocells[i].cell_type;
      if ((org.ocells[i].cell_type == INPUT) || (org.ocells[i].cell_type == INPUT_OUTPUT))
	{ 
	  row1++;
	  org.ocells[i].loc_y = row1;
	}
      else if (org.ocells[i].cell_type == METAB1)
	{ 
	  row2++;
	  org.ocells[i].loc_y = row2;
	}
      else if (org.ocells[i].cell_type == METAB2)
	{ 
	  row3++;
	  org.ocells[i].loc_y = row3;
	}		
      else if (org.ocells[i].cell_type == OUTPUT)
	{ row4++;
	  org.ocells[i].loc_y = row4;
	}
      else error("Incorrect organism layout. Please check the number of cells and declarations.");
    }

  // filling molecular data
  int cx, cy;
  int n_of_mol, ROWS, COLS;
  gdata.total_number_of_molecules = 0;
  for(i=1; i<= gdata.number_of_cells; i++)
    {
      cx = 1; cy =1;
      ROWS = org.ocells[i].x; // ROWS
      COLS = org.ocells[i].y; // COLS     
      n_of_mol = org.ocells[i].cell_n_molec;
      gdata.total_number_of_molecules =  gdata.total_number_of_molecules + n_of_mol;
      org.ocells[i].is_active = 0;
		if ((org.ocells[i].cell_n_r_mol+org.ocells[i].cell_n_e_mol+org.ocells[i].cell_n_i_mol) !=
			 org.ocells[i].cell_n_molec)
			  error("Incorrect number of receptor, effector, or internal molecules at cell ", i);
      for(j=1; j<=org.ocells[i].cell_n_molec; j++)
	{ 
	  org.ocells[i].mols[j].loc_x = cx; // row
	  org.ocells[i].mols[j].loc_y = cy; // col
	  //  cout << j << ": r,c " << cx <<"," <<cy << endl; 
	  if (cy >= org.ocells[i].y)  { cy = 0; cx++; } 
	  cy++;
	  org.ocells[i].mols[j].mol_id = j;
	  
	  org.ocells[i].mols[j].mol_shape.reserve(gdata.shape_size);
	  org.ocells[i].mols[j].r_activation.reserve(gdata.shape_size);
	  org.ocells[i].mols[j].r_inhibition.reserve(gdata.shape_size);    
	  randstring(org.ocells[i].mols[j].mol_shape,gdata.shape_size,myrandom);
	  randstring( org.ocells[i].mols[j].r_activation,gdata.shape_size,myrandom);
	  randstring( org.ocells[i].mols[j].r_inhibition,gdata.shape_size,myrandom);		
	  org.ocells[i].mols[j].flag_inhi = FALSE;
	  org.ocells[i].mols[j].mol_state[0] = READY;
	  org.ocells[i].mols[j].mol_state[1] = NULLSTATE;
	  org.ocells[i].mols[j].mol_type = INTERN;
	  org.ocells[i].mols[j].mol_was_activated = 0;

	  //	  cout << "new molecules at: " << i << "," << j << ":" <<  org.ocells[i].mols[j].mol_shape <<"," << org.ocells[i].mols[j].r_activation.size() << "," << org.ocells[i].mols[j].r_inhibition << endl;
	}
      // assign randomly the receptor and effector molecules
      j = 1;
      int mmolec;
	
      do
	{
	  mmolec = myrandom.Next(1,org.ocells[i].cell_n_molec);
	  //mmolec = myrandom.Next(1,j);
	  if (org.ocells[i].mols[mmolec].mol_type == INTERN)
	    {
	      org.ocells[i].mols[mmolec].mol_type = RECEPTOR;
	      j++;
	      // cout << "i,j=" << i << "," << mmolec << " Rec " << endl; 
	    }
	}
      while (j<=org.ocells[i].cell_n_r_mol);
      j=1;
      do
	{
	  mmolec = myrandom.Next(1,org.ocells[i].cell_n_molec);
	  if (org.ocells[i].mols[mmolec].mol_type == INTERN)
	    {
	      org.ocells[i].mols[mmolec].mol_type = EFFECTOR;
	      j++;
	    }
	}
      while (j<=org.ocells[i].cell_n_e_mol);
    }
}

void read_input_file(char argv[], a_s Minput_v[], a_s Mdesired_v[], global_data &gdata) 
{ 
  
  int k,i = 1;
  int cc = 0;
  // cout << "Reading input file " << endl;
  string read_input, read2, strback, v1, v2;
  ifstream input_file(argv, ios::in);
  if (!input_file) error("Input vector file not found!");
  input_file >> cc;
  if (cc <= 0) error("Number of input vectors should be greather than zero ");
  gdata.n_input_v = cc;
  input_file >> gdata.input_string_length; // string length
  input_file >> gdata.output_string_length; // output s l 
  // the following values does not matter because you are splitting the vectors
  if ( gdata.input_string_length > max_input_shape_size) error("Increase -max_input_shape_size- value ");
  if ( gdata.output_string_length > max_input_shape_size) error("Increase -max_input_shape_size- value ");
  // cout << "Reading input file "  << argv << endl;
  
  while (!input_file.eof())
    { 	
      strcpy(Minput_v[i].data,"\0");
      strcpy(Mdesired_v[i].data,"\0");
      input_file >> Minput_v[i].data;
      input_file >> Mdesired_v[i].data;
       
      for (k=0; k<gdata.input_string_length; k++)
	{
	  if ( (Minput_v[i].data[k] != '0') && (Minput_v[i].data[k] != '1')
	       && (Minput_v[i].data[k] != 'X') )
	    error("Incorrect character [allowed only '0','1', or 'X'] in input data at line ", i);
	}
      
       for (k=0; k<gdata.output_string_length; k++)
	{
	  if ( (Mdesired_v[i].data[k] != '0') && (Mdesired_v[i].data[k] != '1'))
	    error("Incorrect character [allowed only '0','1'] in desired output at line ", i);
	}

      if (strcmp(Minput_v[i].data,"") == 0) break;
      //      cout << i << ", " << Minput_v[i].data  << ", " << Mdesired_v[i].data <<  endl;
      i++;
      if (i > cc) break;
    }
  input_file.close();
  i--;
  // cout << cc << " i " << i << endl;
  if (i != cc)
    { //cout <<" InpuShould be " << cc << " , it is " << i << "; ";
      error("Incorrect number of input vectors, current count is ", i); 
    }
  // cout << "eof read input file " << endl;
}

void read_test_file(char argv[], a_s test_v[], int &test_string_length,  int &c)
{ 
  // c == number of input vectors !!
  int i = 1;
  int cc = 0;
  string read_input, strback, v1;
  ifstream input_file(argv,ios::in);
  if (!input_file) error("Test vector file not found!" );
  input_file >> cc;
  c = cc;
  input_file >> test_string_length; // test string length
  while(!input_file.eof())
    { 
      strcpy(test_v[i].data,"\0");
      input_file >>  test_v[i].data;
      if (strcmp(test_v[i].data,"") == 0) break;     
      i++;
      if (i > cc ) break;
    }
  input_file.close();
  i--;
  // cout << cc << " i " << i << endl;
  if (i != cc)
    { //cout <<" InpuShould be " << cc << " , it is " << i << "; ";
      error("Incorrect number of test vectors, current count is ", i); 
    }  
  // cout << "End of reading test file " << endl;
  //return 0;
}
 
/////////
void saving_results_mol_step(organism myorg, global_data gd, int state)
{ 
  int i,j;//,rr;
  char fileres[512];
  //  char id[8];
  char *pid = NULL;
  int int_id;
  int maxrow;
  int_id = gd.c_time;
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, "tmplot/");
  strcat(fileres, "organism-r");
  strcat(fileres, pid);
  //  cout << "FILE:" << fileres << "." << endl;
  ofstream res_file(fileres, ios::out); // | ios::app);
  if (!res_file) error("Result file not found!");   
  for (i=1; i<=myorg.ncells ; i++) // for every cell
    { maxrow = myorg.ocells[i].x;
      for (j=1; j<=myorg.ocells[i].cell_n_molec; j++) // for every molecule
	{
	  //res_file_ << i;
	  //res_file << "\t";
	  //res_file << j << "\t";
	  //res_file <<  myorg.ocells[i].mols[j].mol_type << "\t";
	  res_file <<  myorg.ocells[i].mols[j].loc_x << "\t" << myorg.ocells[i].mols[j].loc_y << "\t";
	  //res_file <<  myorg.ocells[i].mols[j].mol_shape << "\t" ;
	  res_file << myorg.ocells[i].mols[j].mol_state[state] << "\t";
	  //res_file <<  myorg.ocells[i].mols[j].r_inhibition << "\t" << myorg.ocells[i].mols[j].mol_in_readout << "\t";
	  //	res_file <<  myorg.ocells[i].mols[j].flag_inhi;
	  // if ((j % maxrow) == 0)
	  res_file << endl;
	  if ((j % maxrow) == 0 ) res_file << endl; 
	}
      res_file  << endl;
    }
  res_file << endl;
  res_file.close();  
}





int read_organism_file(char * argv[], organism myorg, global_data gd)
{
  int i,j; //,rr;
  char fileres[512];
  // char id[32];
  int n1, n2;
  char id[8];
  char *pid = NULL;
  int int_id;
  int epoch;
  double readerror;
  strcpy(id, argv[3]);
  int_id = atoi(id);
  int_id = gd.n_iter; 
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, argv[1]);
  strcat(fileres, "-organism.txt");
  //  strcat(fileres, pid);
  ifstream res_file(fileres);
  //  ofstream res_file("organism");
  if (!res_file) error("Organism file not found!");   
  res_file >> epoch;
  res_file >> readerror;
  cout << "Reading organism data at epoch: " << epoch << endl;
  cout << "Training performance registered at file: " << readerror << endl;
  while (!res_file.eof())
    {
      res_file >> i; 
      res_file >> j;
      res_file >> myorg.ocells[i].mols[j].mol_type;
      res_file >>  myorg.ocells[i].mols[j].loc_x; 
      res_file >> myorg.ocells[i].mols[j].loc_y;
      res_file >>  myorg.ocells[i].mols[j].mol_shape; 
      res_file >>  myorg.ocells[i].mols[j].r_activation;
      res_file >>  myorg.ocells[i].mols[j].r_inhibition; 
      res_file >> n1;
      myorg.ocells[i].mols[j].mol_in_readout = n1 ;
      res_file >> n2;
      myorg.ocells[i].mols[j].flag_inhi = n2; 
      // cout << i << "," << j << "," << myorg.ocells[i].mols[j].mol_type << ":" <<  myorg.ocells[i].mols[j].mol_shape << ",";
      //cout << (int) myorg.ocells[i].mols[j].flag_inhi << endl;
    }
  //	cout << "End of reading" << endl;
  res_file.close(); 
  return epoch;
}

void save_organism_file(char * argv[], organism myorg, global_data gd)
{
  int i,j; //,rr;
  char fileres[512];
  // char id[32];
  //  int n1, n2;
  char id[8];
  char *pid = NULL;
  int int_id;
  string scrap;
  strcpy(id, argv[3]);
  int_id = atoi(id);
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, argv[1]);
  strcat(fileres, "-organism.txt");
  //  strcat(fileres, pid);
  ofstream res_file(fileres);
  if (!res_file) error("Organism file cannot be created!"); 
  res_file << gd.actual_iter << endl;
  res_file << gd.g_error << endl;
  for (i=1; i<=myorg.ncells ; i++) // for every cell
    for (j=1; j<=myorg.ocells[i].cell_n_molec; j++) // for every molecule
      {    
	//cout << i << "," << j << "," << myorg.ocells[i].mols[j].mol_type << ":" 
	//     <<  myorg.ocells[i].mols[j].mol_shape << "," << myorg.ocells[i].mols[j].r_activation << "," 
	//     <<  myorg.ocells[i].mols[j].r_inhibition << "," << (int) myorg.ocells[i].mols[j].flag_inhi << endl;
	
	res_file << i << "\t";
	res_file << j << "\t";
	res_file << myorg.ocells[i].mols[j].mol_type << "\t";
	res_file <<  myorg.ocells[i].mols[j].loc_x << "\t"; 
	res_file << myorg.ocells[i].mols[j].loc_y << "\t";
	scrap = myorg.ocells[i].mols[j].mol_shape;
	res_file << scrap << "\t";
	scrap = myorg.ocells[i].mols[j].r_activation;
	res_file << scrap << "\t";
	scrap = myorg.ocells[i].mols[j].r_inhibition;
	res_file << scrap << "\t";
	//	res_file <<  myorg.ocells[i].mols[j].mol_shape << "\t"; 
	//	res_file <<  myorg.ocells[i].mols[j].r_activation << "\t";
	//	res_file <<  myorg.ocells[i].mols[j].r_inhibition << "\t";
	
	res_file << myorg.ocells[i].mols[j].mol_in_readout  << "\t";
	res_file <<  myorg.ocells[i].mols[j].flag_inhi  << endl; 
 

      }
  //	cout << "End of reading" << endl;
  res_file.close(); 
}


void read_global_file(char * argv[], global_data &gdata )
{
  int i,j; //,rr;
  char fileres[512];
  // char id[32];
  //  int n1, n2;
  char id[8];
  char *pid = NULL;
  int int_id;
  strcpy(id, argv[3]);
  int_id = atoi(id);
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, argv[1]);
  strcat(fileres, "-global-r");
  strcat(fileres, pid);
  ifstream res_file(fileres);
  //  ofstream res_file("organism");
  if (!res_file) error("Global file not found");    
  char name[128]; 
  int d1, d2; float mye;
  while(!res_file.eof() )  
    {
      res_file >> name;
      if (strcmp(name,"seeds") == 0) 
	{ 			 
	  res_file >> d1; 
	  gdata.seed1 = d1; 
	  res_file >> d2;
	  gdata.seed2 = d2;
	  if ((d1 <=0) || (d2 <=0)) error("seeds in global file should be positive");		 
	}
      if (strcmp(name,"iterations") == 0) 
	{
	  res_file >> d1;
	  if (d1 <= 0) error("Iterations in global file should be positive");
	  gdata.actual_iter = d1;
	}
      if (strcmp(name,"global_error") == 0)
	{
	  res_file >> mye;
	  gdata.g_error = mye;
	}
    }
  res_file.close();
}

void check_files(char * argv[])  // return 0 if OK, 1 otherwise.
{
  int i,j; //,rr;
  char fileres[512];
  // char id[32];
  //  int n1, n2;
  char id[8];
  char *pid = NULL;
  int int_id;
  strcpy(id, argv[3]);
  int_id = atoi(id);
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, argv[1]);
  strcat(fileres, "-organism-r");
  strcat(fileres, pid);
  ifstream res_file; 
  res_file.open(fileres);
  if (res_file.fail())
    {
      res_file.close();
      error("File do not exists ", fileres);
    }  
  strcpy(fileres, argv[1]);
  strcat(fileres, "-global-r");
  strcat(fileres, pid);
  ifstream res_file2; 
  res_file2.open(fileres);
  if (res_file2.fail())
    {
      res_file2.close();
      error("File do not exists ", fileres);
    } 
}


// Plot the organism as ppm file.
// The organisms should have cells with the same size in each layer
// for best results
// Cells if different sizes in different layers are allowed.

void plot_org_ppm(organism &myorg,  long time, array_aux a_org[])  
{
  int i,j;//,rr;
  char fileres[512]; char filenameps[512];
 
 
  char *pid = NULL;
  long int_id;
  
  int_id = time;
  pid = fcvt((double)int_id, 0, &i, &j);
  double maxval;  
  strcpy(fileres, "plotorg/");
  strcat(fileres, "org-t");
  strcat(fileres, pid);
  strcpy(filenameps,fileres);
  strcat(fileres, ".pl");
  strcat(filenameps, ".ps");
  //  cout << "FILE:" << fileres << "." << endl;
  ofstream res_file(fileres, ios::out);//, ios::app);
  if (!res_file) error("I cannot open .tk file. Create 'plotorg' directory.");
  maxval = 0.0;

  int ncell, nmol, molcounter = 0;
  if (maxval <= 1.0) maxval = 255;
  
  // finding MSIZE as the number of total rows plus number of cells of the largest layer
  int MSIZE=100;
  int MOLSIZE =20;
  // loop to gather statistics to generate a plot
  int MAXCOLS, SUMCOLS_INPUT, SUMCOLS_INTERNAL1, SUMCOLS_INTERNAL2, SUMCOLS_OUTPUT;
  int MAXROWS, SUMROWS_INPUT, SUMROWS_INTERNAL1, SUMROWS_INTERNAL2, SUMROWS_OUTPUT;
  
  int c_input, c_internal1, c_internal2, c_output;
  
  c_input= c_internal1 = c_internal2 = c_output = 0;
  
  MAXCOLS = 0;
  MAXROWS = 0;
  SUMCOLS_INPUT = SUMCOLS_INTERNAL1 =SUMCOLS_INTERNAL2 = SUMCOLS_OUTPUT = 0;
  MAXROWS =  SUMROWS_INPUT = SUMROWS_INTERNAL1 =  SUMROWS_INTERNAL2 = SUMROWS_OUTPUT = 0;
  int sumcolumns, sumrows;
  sumcolumns = 0;
  sumrows = 0;
  //  cout << time << " Max " << MAXCOLS << "+" << sumcolumns << endl;
  for (ncell = 1; ncell <= myorg.ncells; ncell++)   
    { // for each cell 
      if ((myorg.ocells[ncell].cell_type == INPUT) ||(myorg.ocells[ncell].cell_type == INPUT_OUTPUT))   {
	SUMCOLS_INPUT = SUMCOLS_INPUT + myorg.ocells[ncell].x; c_input++;
	SUMROWS_INPUT = myorg.ocells[ncell].y;
      }
      if (myorg.ocells[ncell].cell_type == METAB1) { 
	SUMCOLS_INTERNAL1 = SUMCOLS_INTERNAL1 + myorg.ocells[ncell].x; c_internal1++;
	SUMROWS_INTERNAL1 =   myorg.ocells[ncell].y;
      }
      if (myorg.ocells[ncell].cell_type == METAB2) {
	SUMCOLS_INTERNAL2 = SUMCOLS_INTERNAL2 + myorg.ocells[ncell].x; c_internal2++;
	SUMROWS_INTERNAL2 =   myorg.ocells[ncell].y;
      }
      if (myorg.ocells[ncell].cell_type == OUTPUT) {
	SUMCOLS_OUTPUT = SUMCOLS_OUTPUT + myorg.ocells[ncell].x; c_output++;
	SUMROWS_OUTPUT = myorg.ocells[ncell].y;
      }

      //   cout << ncell << " : "<< SUMCOLS_INPUT << ", " << SUMCOLS_INTERNAL1 << ", " << 	SUMCOLS_INTERNAL2  << ",  " << 	SUMCOLS_OUTPUT << endl;
      //  cout << ncell << " : " << c_input << ", " << c_internal1 << "," << c_internal2 << "," << c_output << endl;
    }

  SUMCOLS_INPUT = SUMCOLS_INPUT + c_input;
  SUMCOLS_INTERNAL1 = SUMCOLS_INTERNAL1 + c_internal1;
  SUMCOLS_INTERNAL2 = SUMCOLS_INTERNAL2 + c_internal2;
  SUMCOLS_OUTPUT = SUMCOLS_OUTPUT + c_output;
  //  cout << "Selecting Max " << MAXCOLS << "+" << sumcolumns << endl;
  if (SUMCOLS_INPUT > SUMCOLS_INTERNAL1)
    {
      MAXCOLS = SUMCOLS_INPUT;
      sumcolumns = c_input;   // cout << "--1 Max " << MAXCOLS << "+" << sumcolumns << endl;
    }
  else
    {
      MAXCOLS = SUMCOLS_INTERNAL1;
      sumcolumns = c_internal1; //   cout << "--2 Max " << MAXCOLS << "+" << sumcolumns << endl;
    }
  if (MAXCOLS < SUMCOLS_INTERNAL2)
    {
      MAXCOLS = SUMCOLS_INTERNAL2;
      sumcolumns = c_internal2; // cout << "--3 Max " << MAXCOLS << "+" << sumcolumns << endl;	   
    }
  if (MAXCOLS < SUMCOLS_OUTPUT)
    {
      MAXCOLS = SUMCOLS_OUTPUT;
      sumcolumns = c_output;    // cout << "--4 Max " << MAXCOLS << "+" << sumcolumns << endl;	  
    }
  MAXCOLS = MAXCOLS + 0;
  MAXROWS =  SUMROWS_INPUT + SUMROWS_INTERNAL1 + SUMROWS_INTERNAL2 + SUMROWS_OUTPUT + 8;
  //  cout << "Max " << MAXCOLS << "+" << sumcolumns << "rOWS " << MAXROWS <<  endl;

  res_file << "#!/usr/bin/perl -w" << endl;
  res_file << "use Tk;" << endl;
  res_file << "my $padding = 10; " <<endl;
  res_file << "my $height = " << MAXCOLS*MOLSIZE << ";" << endl;
  res_file << "my %pane    = ( width =>  10, height => $height );" <<endl;
  res_file << "my %canvas  = ( width => " << MAXROWS*MOLSIZE << ", height => $height); " <<endl;
  res_file << "my %window  = ( width => $pane{width}+$canvas{width}+4*$padding, height => $height+2*$padding );" << endl;
  res_file << "my $mw = MainWindow->new;" << endl;  
  res_file << "$mw->configure( -width=>$window{width}, -height=>$window{height});" << endl;
  res_file << "$mw->title('Hypernetwork at clocktime =" << time << "');" << endl;
  res_file << "my $pane = $mw->Frame; "<< endl;
  res_file << "$pane->pack( -side=>'left', -padx=>$padding, -pady=>$padding, -fill=>'both' );" << endl;
  res_file << "$pane->Button( -text=>'Continue', -command=>sub{ exit } )->pack( -side=>'top',-pady=>$padding );" << endl;
  res_file << "my  $canvas = $mw->Canvas(-cursor=>'crosshair', -background=>'white',-width=>$canvas{width}, -height=>$canvas{height}); " << endl;
  res_file << "$canvas->pack (-side=>'right', -padx=>$padding, -pady=>$padding);" << endl;
    

  int this_state =0;
  int xbasecell, ybasecell, mx,my;
  int columnsoffset =0;
  molcounter = 1;
  xbasecell = 0;
  ybasecell = 0;
  // cout << "cell=" << ncell << " xbase, ybase=" << xbasecell << ", " << ybasecell << endl;
  // cout << "Press Ctrl-Break to end the simulation or Exit to continue. " << endl; 
  // CHECK INTERNAL CELLS
    for (ncell = 1; ncell <= myorg.ncells; ncell++)   
      {
	if ((c_internal2 == 0) && (myorg.ocells[ncell].loc_x > METAB2))
	myorg.ocells[ncell].loc_x--;
      }
    
 for (ncell = 1; ncell <= myorg.ncells; ncell++)   
      {
	if ((c_internal1 == 0) && (myorg.ocells[ncell].loc_x > METAB1))
	myorg.ocells[ncell].loc_x--;
      }

  for (ncell = 1; ncell <= myorg.ncells; ncell++)   
      {
	if ((c_output == 0) && (myorg.ocells[ncell].loc_x > INPUT))
	myorg.ocells[ncell].loc_x--;
      }

  for (ncell = 1; ncell <= myorg.ncells; ncell++)   
    { // for each cell 
          
      //      cout << " cell = " << ncell << "loc x,y,=" <<myorg.ocells[ncell].loc_x-1 << ", " << myorg.ocells[ncell].loc_y-1  << endl;

       xbasecell =  (myorg.ocells[ncell].loc_x-1)*(myorg.ocells[ncell].x+1)*MOLSIZE;
       ybasecell = (myorg.ocells[ncell].loc_y-1)*(myorg.ocells[ncell].y+1)*MOLSIZE;

      for (nmol=1; nmol<= myorg.ocells[ncell].cell_n_molec; nmol++)
	{ // for each mol						 
	  this_state = a_org[molcounter].current_state;  
	  mx = xbasecell + (myorg.ocells[ncell].mols[nmol].loc_x-1)*MOLSIZE+1; //*myorg.ocells[ncell].mols[nmol].loc_x;  
	  my = ybasecell + (myorg.ocells[ncell].mols[nmol].loc_y-1)*MOLSIZE+1; //*(myorg.ocells[ncell].mols[nmol].loc_y);
	  //  cout << nmol << " mx, my" << mx << "," << my << endl;
	  if (myorg.ocells[ncell].mols[nmol].mol_in_readout > 0)
	    res_file << "$canvas->createRectangle(" << mx-1 << "," << my-1 << "," << mx+MOLSIZE-1 << ","
		       << my+MOLSIZE-1 <<  ",-fill=>'green');" << endl;	 
	    
	  if (this_state == READY)
	    {
	      res_file << "$canvas->createRectangle(" << mx << "," << my << "," << mx+MOLSIZE-3 << ","
		       << my+MOLSIZE-3 <<  ",-fill=>'LightYellow1');" << endl;
	    
	    //res_file << "$canvas->createPolygon(" << mx << "," << my << "," << mx-MOLSIZE-1 << ", " 
	    //     << my+MOLSIZE << ", " << mx+MOLSIZE-1 << "," << my+MOLSIZE << ",-fill=>'green');" << endl;
	    }
	  else
	    if (this_state == ACTIVE)
	       res_file << "$canvas->createRectangle(" << mx << "," << my << "," << mx+MOLSIZE-3 << ","
		     << my+MOLSIZE-3 <<  ",-fill=>'maroon1');" << endl;
	  

	      // res_file << "$canvas->createPolygon(" << mx << "," << my << "," << mx-MOLSIZE-1 << ", " 
	      //       << my+MOLSIZE << ", " << mx+MOLSIZE-1 << "," << my+MOLSIZE <<",-fill=>'red');" << endl;
	    else
	      if (this_state == INACTIVE)

		res_file << "$canvas->createRectangle(" << mx << "," << my << "," << mx+MOLSIZE-3 << ","
	   << my+MOLSIZE-3 <<  ",-fill=>'SkyBlue1');" << endl;
		//	res_file << "$canvas->createPolygon(" << mx << "," << my << "," << mx-MOLSIZE-1 << ", " 
		//	 << my+MOLSIZE << ", " << mx+MOLSIZE-1 << "," << my+MOLSIZE <<",-fill=>'blue');" << endl;
	      else
		error("Incorrect state");
	  
	  res_file << "$canvas->createText(" << mx+MOLSIZE/2-1 << "," << my+MOLSIZE/2-1 << ",-text=>";
	  //  		res_file << "'" << molcounter << "');" << endl;
		
			
	  if (myorg.ocells[ncell].mols[nmol].mol_in_readout > 0)
	    res_file << "'" << a_org[molcounter].t_activations_for_ivector   << "' , -font=>'-family times', -font=>'-size 14'  );" << endl;
	  else 
	    if (a_org[molcounter].mol_type == RECEPTOR)
	      res_file << "'r', -font=>'-family times', -font=>'-size 14');" << endl;
	    else
	      if (a_org[molcounter].mol_type == EFFECTOR)
		res_file << "'e'  , -font=>'-family times', -font=>'-size 14');" << endl;
	      else
		res_file << "'');" << endl;	  
	  molcounter ++;
	}

      //     cout << "cell=" << ncell << " xbase, ybase=" << xbasecell << ", " << ybasecell << endl;
    }
  res_file << "$canvas->update();" << endl;
  res_file << "$canvas->postscript(-file=>'" << filenameps  <<"');" << endl;
  res_file << "MainLoop;" << endl;
  res_file.close();
  char comm[60];
  strcpy(comm,"");
  strcat(comm, "chmod oug+x ");
  strcat(comm, fileres);
  int ret = system(comm);
  ret = system(fileres);
   if (WIFSIGNALED(ret) &&
        (WTERMSIG(ret) == 1 || WTERMSIG(ret) == 2))
     error("Program canceled by Ctrl-Break.");

}

int read_organism_file_pop(char * argv[], organism myorg, global_data gd, int npop)
{
  int i,j; //,rr;
  char fileres[512];
  // char id[32];
  int n1, n2;
  char id[8];
  char *pid = NULL;
  int int_id;
  int epoch;
  double readerror;
  int_id = npop;
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, argv[1]);
  strcat(fileres, "_tmp/");
  strcat(fileres, "o-");
  strcat(fileres, pid);
  ifstream res_file(fileres);
  //  ofstream res_file("organism");
  if (!res_file) error("Organism file not found!");   
  res_file >> epoch;
  res_file >> readerror;
  //  cout << "Reading Epoch : " << epoch << ", Training Learning: " << readerror << endl;
  while (!res_file.eof())
    {
      res_file >> i; 
      res_file >> j;
      res_file >> myorg.ocells[i].mols[j].mol_type;
      res_file >>  myorg.ocells[i].mols[j].loc_x; 
      res_file >> myorg.ocells[i].mols[j].loc_y;
      res_file >>  myorg.ocells[i].mols[j].mol_shape; 
      res_file >>  myorg.ocells[i].mols[j].r_activation;
      res_file >>  myorg.ocells[i].mols[j].r_inhibition; 
      res_file >> n1;
      myorg.ocells[i].mols[j].mol_in_readout = n1 ;
      res_file >> n2;
      myorg.ocells[i].mols[j].flag_inhi = n2; 
      // cout << i << "," << j << "," << myorg.ocells[i].mols[j].mol_type << ":" <<  myorg.ocells[i].mols[j].mol_shape << ",";
      //cout << (int) myorg.ocells[i].mols[j].flag_inhi << endl;
    }
  //	cout << "End of reading" << endl;
  res_file.close(); 
  return epoch;
}



void save_organism_file_pop(char * argv[], organism myorg, global_data gd, int npop)
{
  int i,j; //,rr;
  char fileres[512];
  // char id[32];
  //  int n1, n2;
  char id[8];
  char *pid = NULL;
  int int_id;
  string scrap;
  int_id = npop;
  pid = fcvt((float)int_id, 0, &i, &j);
  strcpy(fileres, argv[1]);
  strcat(fileres,"_tmp/");
  strcat(fileres, "o-");
  strcat(fileres, pid);
  ofstream res_file(fileres);
  if (!res_file) error("Organism file cannot be created!"); 
  res_file << gd.actual_iter << endl;
  res_file << gd.g_error << endl;
  for (i=1; i<=myorg.ncells ; i++) // for every cell
    for (j=1; j<=myorg.ocells[i].cell_n_molec; j++) // for every molecule
      {    
	//cout << i << "," << j << "," << myorg.ocells[i].mols[j].mol_type << ":" 
	//     <<  myorg.ocells[i].mols[j].mol_shape << "," << myorg.ocells[i].mols[j].r_activation << "," 
	//     <<  myorg.ocells[i].mols[j].r_inhibition << "," << (int) myorg.ocells[i].mols[j].flag_inhi << endl;
	
	res_file << i << "\t";
	res_file << j << "\t";
	res_file << myorg.ocells[i].mols[j].mol_type << "\t";
	res_file <<  myorg.ocells[i].mols[j].loc_x << "\t"; 
	res_file << myorg.ocells[i].mols[j].loc_y << "\t";
	scrap = myorg.ocells[i].mols[j].mol_shape;
	res_file << scrap << "\t";
	scrap = myorg.ocells[i].mols[j].r_activation;
	res_file << scrap << "\t";
	scrap = myorg.ocells[i].mols[j].r_inhibition;
	res_file << scrap << "\t";
	res_file << myorg.ocells[i].mols[j].mol_in_readout  << "\t";
	res_file <<  myorg.ocells[i].mols[j].flag_inhi  << endl; 
      }
  //	cout << "End of saving" << endl;
  res_file.close(); 
}



