/////////////////////////////////////////////////////////////////
// cran32.h: Class implementation for a combined 32 bit
// linear congruential uniform random number generator.
// Copyright (c) 1994 Azarona Software. All rights reserved. 
// NOTE: This generator only works when long is 32 bits or more. 
//////////////////////////////////////////////////////////////////

#ifndef H_CRAN32
#define H_CRAN32
 
class CRan32 {

protected: 
  static const long a1, m1, q1, r1;
  static const long a2, m2, q2, r2;
  long seed1, seed2, curr; 

public: 
  CRan32(long s1, long s2); 
  void Reset(long s1, long s2); 
  long Curr() const; 
  long Step(); 
  long Next(); 
  long Curr(long n) const; 
  long Next(long n); 
  long Curr(long lo, long hi) const; 
  long Next(long lo, long hi); 
}; 
 
inline CRan32::CRan32(long s1, long s2) 
{ 
  Reset(s1, s2); 
} 
 
inline long CRan32::Curr() const 
// Returns the current element of the random number sequence. 
{ 
  return curr; 
} 
 
inline long CRan32::Step() 
{ 
  return Next(); 
} 
 
inline long CRan32::Curr(long n) const 
// Returns the current value cv scaled such that 0 <= cv < n. 
{ 
  return Curr() % n; 
} 
 
inline long CRan32::Next(long n) 
// Advances to the next random number nv, and 
// scales it's value such that 0 <= nv < n. 
{ 
  return Next() % n; 
} 
 
#endif 
 
