#ifndef SIMFUNC_H
#define SIMFUNC_H

#include "objects.h"
#include "constants.h"
#include "cran32.h"
#include <iostream>
#include <string>
#include <time.h>
#include <stdlib.h>

void warming_up_random(CRan32 &myrandom);
void print_data_org(organism myorg);

void update_cells_num(int CELL_TYPE, int MOL_TYPE, organism &org, global_data gdata);

int matching_string_int(unsigned short a, unsigned short b, int vec_size);


void set_readout_molecules_random(organism &org, CRan32 &rnd)  ;

void set_inhibitor_molecules(organism &myorg, global_data gd, CRan32 &rnd)  ;

void update_distances(organism &myorg, global_data gdata, array_aux a_org[]);
void set_counters_initial(organism &myorg);

double epoch_pop(organism &myorg, global_data &gd, a_s input_v[],  a_s output_v[], a_s desired_v[], CRan32 &rnd, array_aux a_org[], int typeloop) ;

double epoch(organism &myorg, global_data &gd, a_s input_v[],  a_s output_v[], a_s desired_v[], CRan32 &rnd, array_aux a_org[], int typeloop)  ;

void delete_organism(organism &orig);

int change_mol_structure_prob(organism &myorg, global_data gd, CRan32 &rnd) ;
void activate_input_cells_states_with_n( a_s input_v[], int j_v, organism &myorg, global_data &gd, int nsize,array_aux a_org[]);

double evaluate_global_error(a_s input_v[], a_s desired_v[], a_s output_v[], int n_input_v, int vec_size, global_data gd)  ;
double evaluate_global_error_TESTING(a_s input_v[], a_s desired_v[], a_s output_v[], int n_input_v, int vec_size, global_data gd) ;

void fill_mol_interaction(int molcount, int offset, int ncell, int nmol, int nextrow, int nextcol, organism &org, global_data gdata, array_aux a_org[]);


void create_copy_organism(organism &dest, organism orig)  ;
void just_copy_organism(organism &dest, organism orig)  ;


void fill_relation_array(organism &myorg, global_data gdata, array_aux a_org[]);

void set_molecules_initial(organism &myorg, array_aux a_org[])    ;

void spread_influences_organism(organism &myorg,  global_data &gd, array_aux a_org[])  ;


void  get_output_vector_or_mode(a_s output_v[], int nv, organism myorg,  global_data gd)  ;

#endif // SIMFUNC_H
