#include "constants.h"  
#include "objects.h"  
#include "simfunc04.h"
#include "filemag04.h"
#include "misc.h"  
#include <math.h>   
#include <iomanip>

bool printdebug = FALSE; 

/* 

   This is an implementation of the hypernetwork architecture
   learning algorithm
   June/July 2004.
   (c) Jose L. Segovia-Juarez, 1999-2004.

*/


// assuming 32 bits integer
// send string backwards
void int32_to_string(string &a, int n) 
{
  string mystring(32,'X'); 
  for (long i=31; i>=0; i--) {
    int bit = ((n >> i) & 1);
    if (bit == 0)
      mystring.at(i) = '0';//"+mystring;
    else 
      mystring.at(i) = '1';//+mystring;
  }
  a=mystring; 
}

// update molecules with a sequential string. Used  
// to update structures of molecules on input cells
void update_cells_num(int CELL_TYPE, int MOL_TYPE, organism &org, global_data gdata )
{
  int i,j, top;
  unsigned short int mynum = 0;
  int ncell, totalncells, totalnmol = 0;
  int d = gdata.shape_size;
  // for every cell
  string wordof32 (32,'0');
  totalncells = org.ncells;
  for (ncell = 1; ncell <= totalncells; ncell++)
    {
      mynum=0;
      totalnmol = org.ocells[ncell].cell_n_molec;
      if (org.ocells[ncell].cell_type == CELL_TYPE)
		  {
			 for(i=1; i <= totalnmol; i++)
				{
				  if (org.ocells[ncell].mols[i].mol_type == MOL_TYPE)
					 {
						int32_to_string(wordof32,mynum);
						//cout << "d=" << d << "."<< wordof32.size() << ":" << org.ocells[ncell].mols[i].r_activation.size() << endl;
						for (j=0; j<d; j++) org.ocells[ncell].mols[i].r_activation.at(j) = '0';
						if (d >= 32)
						  top = 31;
						else
						  top = d;
						for (j=0; j<top; j++)
						  org.ocells[ncell].mols[i].r_activation.at(j) = wordof32.at(j);
						mynum++;
					 }
				}
		  }
    }
}
 
 
// print data of the organism 
 
void print_data_org(organism myorg)   
{   
  int i,j, ROWS, COLS;    
  cout << "Organism with " << myorg.ncells << " cells " << endl;   
  // cout << "shape size = " << myorg.shape_size << endl;   
  for (i=1; i<=myorg.ncells ; i++)   
    {   
      cout << "Cell: " << i << "\tN,R,I,E: " << myorg.ocells[i].cell_n_molec << ", " << myorg.ocells[i].cell_n_r_mol << ", " << myorg.ocells[i].cell_n_i_mol << "," <<  myorg.ocells[i].cell_n_e_mol << " X,Y="  << myorg.ocells[i].x << "," << myorg.ocells[i].y << " LocX,Y=" << myorg.ocells[i].loc_x <<"," << myorg.ocells[i].loc_y << " nreadout = " << myorg.ocells[i].cell_n_readout << endl;   
      cout << "Cell-Interactions : "; 
      for(j=0; j < (int)myorg.ocells[i].interaction_cell.size() ; j++) 
		  cout << myorg.ocells[i].interaction_cell[j] << "\t"; 
      cout << endl; 
      ROWS = myorg.ocells[i].x; 
      COLS = myorg.ocells[i].y; 
      for (j=1; j<=myorg.ocells[i].cell_n_molec; j++)   
		  {   
			 cout << myorg.ocells[i].cell_id << "\t"  
					<< myorg.ocells[i].mols[j].mol_id << "\t"    
					<< myorg.ocells[i].mols[j].r_activation << "\t"     
					<< myorg.ocells[i].mols[j].r_inhibition << "\t"    
					<< myorg.ocells[i].mols[j].mol_shape <<  "\t"  
					<< myorg.ocells[i].mols[j].mol_type  << "\t" 
					<< myorg.ocells[i].mols[j].flag_inhi << "\t" 
					<< "x,y:";   
			 cout << myorg.ocells[i].mols[j].loc_x << ", " << myorg.ocells[i].mols[j].loc_y << " ";   
			 cout << "\t aux:  " << myorg.ocells[i].mols[j].pointer_to_aux << "\tS:";   
			 cout << myorg.ocells[i].mols[j].mol_shape.size() << "," << myorg.ocells[i].mols[j].r_activation.size() << "," << myorg.ocells[i].mols[j].r_inhibition.size() << endl;

		  }   
    }   
}   
 
 
// display data of the aux array 
void print_data_aux( array_aux a_org[], organism myorg) 
{ 
  int ncell, i, k, in, numcells, nummol; 
  int molcount = 1; 
  numcells = myorg.ncells; 
  cout << "\nData aux " << endl;
  for (ncell = 1; ncell <= numcells; ncell++)   
         
    { // for ncell	   
      nummol = myorg.ocells[ncell].cell_n_molec;	            
      for(in=1; in <= nummol; in++)   
		  { // for i nmol  
			 cout << molcount << ", cell,mol= " << ncell << "," << in  << "\t" << a_org[molcount].mol_id   << "\t" << a_org[molcount].cell_type; 
			 cout << "\t" << a_org[molcount].mol_type << "\t R A: "; 
			 for (i=0; i<8; i++) 
				cout << a_org[molcount].activations[i] << ", "; 
			 cout << "\t R I: "; 
			 for (i=0; i<8; i++)  
				cout << a_org[molcount].inhibitions[i] << ", "; 
			 k = 0;
			 cout << "\t C-C: -" << a_org[molcount].cell_cell_activation.size() << " = ";
			 while ((int)a_org[molcount].cell_cell_activation.size() > k)
				{
				  cout << a_org[molcount].cell_cell_activation[k] << ", ";  
				  k++; 
				}

			 cout << endl; 
			 molcount = molcount + 1; 
		  } 
    } 
	 
} 


// Funtion to find the distance between two strings  a and b 
// Uses precomputed distances found in the tbin array. 

int matching_string(string a, string b, int vec_size)  
{   
  int r1 = 0;  
  int r2 = 0; 
  float f1 = 0.0;
  for (r1=0; r1<vec_size; r1++)
    if (a.at(r1) != b.at(r1)) r2=r2+1;	 
  f1 = r2*100.00/(float)vec_size;  
  r2 = (int)floor(f1);
  return r2;  
};  

// set the locations of the readout structures on the cell 
// on random locations
void set_readout_molecules_random(organism &org, CRan32 &rnd)  
{  
  int numcells, nummol, ncell, numreadout, i, value;  
  numcells = org.ncells;  
  bool done;  
  for (ncell = 1; ncell <= numcells; ncell++)  
    {   
      numreadout = org.ocells[ncell].cell_n_readout;  
      nummol = org.ocells[ncell].cell_n_molec;  
        
      if ((org.ocells[ncell].cell_type == OUTPUT) || (org.ocells[ncell].cell_type == INPUT_OUTPUT))
		  {  
			 // first clean all the readouts  
			 //	cout << ncell << " Setting readout molecules with " << numreadout << "," <<  nummol << endl;  
			 for(i=1; i <= nummol; i++)  
				org.ocells[ncell].mols[i].mol_in_readout = FALSE;  
            
			 for(i=1; i <= numreadout; i++)			    
				{ done = FALSE;  
				  do   
                {  
						value = rnd.Next(1,nummol);  
						if (org.ocells[ncell].mols[value].mol_type == INTERN)
						  if (org.ocells[ncell].mols[value].mol_in_readout != TRUE)  
							 {  
								org.ocells[ncell].mols[value].mol_in_readout = TRUE;  
								done = TRUE;  
								//	cout << "doing readout " << i << ".";  
							 }  
                }  
				  while(done!=TRUE);  
				}  
		  }  
    }  
}  

 
// initialize molecules 

void set_molecules_initial(organism &myorg, array_aux a_org[])    
{  
  int ncell, nmolecell, i, countermol;
  countermol = 1;  
  for (ncell=1; ncell <= myorg.ncells; ncell++)  
    {  
      nmolecell=myorg.ocells[ncell].cell_n_molec;  
      myorg.ocells[ncell].is_active = 0;  
      for (i = 1; i<= nmolecell; i++)  
		  {   
			 myorg.ocells[ncell].mols[i].mol_was_activated=0;   
			 myorg.ocells[ncell].mols[i].mol_state[0] = READY;  
			 myorg.ocells[ncell].mols[i].mol_state[1] = READY;  
		  }
        
	 }
  countermol = 1;  
  for (ncell=1; ncell <= myorg.ncells; ncell++)  
    {  
		nmolecell=myorg.ocells[ncell].cell_n_molec;  
      for (i = 1; i<= nmolecell; i++)  
		  {   
			 a_org[countermol].current_state  = READY;
			 a_org[countermol].n_activations  = 0;
			 a_org[countermol].n_inhibitions  = 0; 
			 a_org[countermol].t_activations_for_ivector = 0;
			 countermol = countermol + 1;
		  }              
    }  
}  

void set_inhibitor_molecules(organism &myorg, global_data gd, CRan32 &rnd)  
{  
  int ncell, i, nmoltot, nmolstochange, nmol;  
  for(ncell = 1; ncell<=myorg.ncells; ncell++)  
    {  
      nmoltot = myorg.ocells[ncell].cell_n_molec;  
      for (i=1;i<=nmoltot; i++)  
		  myorg.ocells[ncell].mols[i].flag_inhi = FALSE;  
      nmolstochange = (int)ceil(nmoltot * (float)myorg.ocells[ncell].p_inhibitors / 100); 
      if (nmolstochange <= 0) error("p_inhibitors_cell < 0 in cell ", ncell );
      if (nmolstochange > nmoltot) error("p_inhibitors_cell > 100 in cell ", ncell );
      //    cout << "n nihibits " << nmolstochange << endl;    
      i = 0;
      while (i < nmolstochange)
		  {  
			 nmol = rnd.Next(1, nmoltot);   
			 if ( myorg.ocells[ncell].mols[nmol].flag_inhi != TRUE)  
				{
				  myorg.ocells[ncell].mols[nmol].flag_inhi = TRUE;  
				  i=i+1;
				}  	     
		  }
	 }  
}   
 
// initialize counters 

void set_counters_initial(organism &myorg)  
{  
  int ncell, nmolecell, i;  
  for (ncell=1; ncell <= myorg.ncells; ncell++)  
    {  
      nmolecell=myorg.ocells[ncell].cell_n_molec;  
      myorg.ocells[ncell].is_active = 0;
    }  
}  
 
// Function that updates an entry of the array with interactions. 

void fill_mol_interaction(int molcount, int offset, int ncell, int nmol, int nextrow, int nextcol, organism &org, global_data gdata, array_aux a_org[])

{  
  int newmol;
  int newdist, newdist_inhi;
  int ROWS, COLS;
    
  ROWS= org.ocells[ncell].x; // ROWS
  COLS = org.ocells[ncell].y; // COLS
    
  newmol = (nextrow -1) * COLS + nextcol; 
 
  if (printdebug == TRUE) 
    {
      cout << "N cell=" << ncell << " mnol = " << nmol << " at aux= " << molcount  << " Offsetactivations = " << offset-1;     }
  if (newmol <= 0) error("Molecule number error!");
  if (nextrow > ROWS) error("Molecule larger on rows");
  if (nextcol > COLS) error("Molecule larger on rows");
    
  newdist = matching_string(org.ocells[ncell].mols[nmol].mol_shape,   
									 org.ocells[ncell].mols[newmol].r_activation,   
									 gdata.shape_size);  
 
  a_org[molcount].activations[offset-1] = 0; 
  a_org[molcount].inhibitions[offset-1] = 0; 

  if (newdist >= gdata.threshold_activation)  
    {  
      // fill appropiate data in the array a_org 
      if (printdebug == TRUE) 
		  cout << "matching :" << newdist << " Activate at= " << newmol << endl;  
      a_org[molcount].activations[offset-1] = ncell* max_n_mol_cell+ newmol;  // newmol;      
    }  
    
  if (org.ocells[ncell].mols[newmol].flag_inhi == TRUE )  
    {   
      newdist_inhi = matching_string(org.ocells[ncell].mols[nmol].mol_shape,  
												 org.ocells[ncell].mols[newmol].r_inhibition,  
												 gdata.shape_size);  
      if (newdist_inhi >= org.ocells[ncell].threshold_inhibition)  
		  {  
			 a_org[molcount].inhibitions[offset-1] =  ncell* max_n_mol_cell+ newmol; //newmol; 
			 if (printdebug == TRUE) 
				cout << " Inhibite at=" << newmol << endl;  
		  }  
    }  
}  

// Function to update the array a_org with interactions  

void fill_relation_array(organism &myorg, global_data gdata, array_aux a_org[]) 

{ // begin fill
  int mrow,mcol, nextx, nexty, ROWS, COLS;  
  int ncell, nmol, nummol; 
  int nextcell, nummolnextcell, nextreceptor;   
  string mol1_shape (gdata.shape_size, 'X');
  string mol2_shape (gdata.shape_size, 'X');  
  int numcells = myorg.ncells; 
  int molcount = 0; // but data starts in one!
  long aquinmol =0;
  long nmol_array;  
      
  for (ncell = 1; ncell <= numcells; ncell++)   
    { 
      nummol = myorg.ocells[ncell].cell_n_molec;
      for(nmol=1; nmol <= nummol; nmol++) 
		  {
			 a_org[molcount].cell_cell_activation.clear();  
			 a_org[molcount].cell_cell_inhibition.clear();  
			 a_org[molcount].cell_cell_activation.reserve(300);
			 a_org[molcount].cell_cell_inhibition.reserve(300);
			 molcount = molcount + 1;  
		  }         
    }

  molcount =1;
  for (ncell = 1; ncell <= numcells; ncell++)  
        
    { // for ncell	  
      nummol = myorg.ocells[ncell].cell_n_molec;	          
      ROWS = myorg.ocells[ncell].x;  
      COLS = myorg.ocells[ncell].y;					          

      for(nmol=1; nmol  <= nummol; nmol++)  
		  { // for i nmol             
			 nmol_array = ncell*max_n_mol_cell+nmol;
			 a_org[molcount].mol_id  = nmol_array;
			 a_org[molcount].cell_type = myorg.ocells[ncell].cell_type;
			 a_org[molcount].mol_type  = myorg.ocells[ncell].mols[nmol].mol_type;
			 a_org[molcount].n_activations = 0;
			 a_org[molcount].n_inhibitions = 0;
			 a_org[molcount].current_state = 0; 
			 a_org[molcount].t_activations_for_ivector = 0; 			 
			 myorg.ocells[ncell].mols[nmol].pointer_to_aux=molcount;
          
			 mrow = myorg.ocells[ncell].mols[nmol].loc_x;  // row
			 mcol = myorg.ocells[ncell].mols[nmol].loc_y;  // col
		 
			 if (printdebug == TRUE) 
				{ cout << "Ncell = " <<ncell << ", nmol=" << nmol << " point to aux at= " << molcount; 
				  cout << " r,c=" << mrow << ", " << mcol << endl; }
			 // 1, n
			 nextx = mrow-1; if (nextx < 1) nextx = ROWS;  
			 nexty = mcol;  
            
			 fill_mol_interaction(molcount,1, ncell, nmol, nextx, nexty, myorg, gdata, a_org);			  
			 // 2  n-e 
			 nextx = mrow -1 ; if (nextx < 1) nextx = ROWS;  
			 nexty = mcol +1 ; if (nexty > COLS) nexty = 1;  
			 fill_mol_interaction(molcount, 2, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // 3  e
			 nextx = mrow;  
			 nexty = mcol +1;  if (nexty > COLS) nexty = 1;  
			 fill_mol_interaction(molcount, 3, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // 4 se  
			 nextx = mrow + 1;  if (nextx > ROWS) nextx = 1;   
			 nexty = mcol + 1;  if (nexty > COLS) nexty = 1;   
			 fill_mol_interaction(molcount, 4, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // 5  S
			 nextx = mrow + 1;  if (nextx > ROWS) nextx = 1;  
			 nexty = mcol ;  
			 fill_mol_interaction(molcount, 5, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // 6 S-O  
			 nextx = mrow + 1;   if (nextx > ROWS) nextx = 1;  
			 nexty = mcol - 1;   if (nexty < 1) nexty = COLS;  
			 fill_mol_interaction(molcount, 6, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // 7  O
			 nextx = mrow;  
			 nexty = mcol - 1;  if (nexty < 1) nexty = COLS;  
			 fill_mol_interaction(molcount, 7, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // 8  
			 nextx = mrow - 1;   if (nextx < 1) nextx = ROWS;  
			 nexty = mcol - 1;   if (nexty < 1) nexty = COLS;				   
			 fill_mol_interaction(molcount, 8, ncell, nmol, nextx, nexty, myorg, gdata, a_org);  
            
			 // now update the cell_cell interactions, In addition to the own neighboors, the   
			 // effector molecules will contact with the exterior.		  
			 // now for effector molecules  
			 int buscacell;
            
			 if ((myorg.ocells[ncell].cell_type != OUTPUT) &&   
				  (myorg.ocells[ncell].mols[nmol].mol_type == EFFECTOR))  
				{  
				  mol1_shape = myorg.ocells[ncell].mols[nmol].mol_shape;	
				  for (buscacell = 0; buscacell < (int)myorg.ocells[ncell].interaction_cell.size() ; buscacell++)
					 {
						nextcell = myorg.ocells[ncell].interaction_cell[buscacell];
						nummolnextcell = myorg.ocells[nextcell].cell_n_molec;  
						//		cout << "C-C ncell, nextcell, nummolnextcell " << ncell << ", " << nextcell <<"," << nummolnextcell  << endl;

						for(nextreceptor=1; nextreceptor<= nummolnextcell; nextreceptor++)    
						  if (myorg.ocells[nextcell].mols[nextreceptor].mol_type == RECEPTOR)  
							 {  
								mol2_shape = myorg.ocells[nextcell].mols[nextreceptor].r_activation;  
								if ( matching_string(mol1_shape, mol2_shape, gdata.shape_size) >=   
									  gdata.threshold_activation )  
								  {                                  
									 aquinmol = nextcell* max_n_mol_cell+nextreceptor;
									 a_org[molcount].cell_cell_activation.push_back(aquinmol);    
									 if (printdebug == TRUE)
										{  cout << "Ncell = " <<ncell << ", nmol=" << nmol ;
										  cout << " Act: " << nextreceptor << " -> " << nextcell* max_n_mol_cell+nextreceptor << endl;
										
										}
								  }   
								if (myorg.ocells[nextcell].mols[nextreceptor].flag_inhi == TRUE)  
								  {   
									 mol2_shape = myorg.ocells[nextcell].mols[nextreceptor].r_inhibition;  
									 if ( matching_string(mol1_shape,mol2_shape, gdata.shape_size) >=   
											myorg.ocells[nextcell].threshold_inhibition )  
										{  
										  aquinmol = nextcell* max_n_mol_cell+nextreceptor;
										  a_org[molcount].cell_cell_inhibition.push_back(aquinmol);  
										  if (printdebug == TRUE)
											 cout << "Adding e-r inh:" << nextcell* max_n_mol_cell+nextreceptor << ", ";
										}  
								  }  
							 } 
						if (printdebug == TRUE) 
						  cout << endl;
					 }  // end for effector molecules		   
				}
          molcount = molcount + 1;
			 if (molcount > (gdata.total_number_of_molecules+1)) error("mc");
		  }
    }
}
 
// State Transicions for 
// internal molecules   
int next_state_int(int current_state)  
{  
  if (current_state == READY) return READY;
  else 
    if (current_state ==  ACTIVE) return INACTIVE;
    else
      if (current_state ==  INACTIVE) return READY;
      else  return WRONG_STATE;
}  
// State Transicions for 
// receptor molecules  
int next_state_rec(int current_state)  
{  
  if (current_state == READY) return READY;
  else 
	 if (current_state ==  ACTIVE) return INACTIVE;
	 else
		if (current_state ==  INACTIVE) return READY;
		else  return WRONG_STATE;
}  


// The output is 1 or 0 for each cell. 
// You can not read molecular states, but cellular states.

void  get_output_vector_or_mode(a_s output_v[], int nv, organism myorg,  global_data gd)  
{  
  int focus = 1;  
  int activatecounter =0;
  char *pres = new char[max_input_shape_size];  
  char *res  = new char[max_input_shape_size];  
  int ncell, nmolecules, nmolcell;  
  strcpy(res, "\0");
  int longitud = gd.output_string_length;
  int counter =0;
  for(int clong=1; clong <= longitud; clong++)
    {
      for (ncell=1; ncell <= myorg.ncells; ncell++)  
		  {   
			 strcpy(pres,"0");  
			 activatecounter = 0;
			 if ((myorg.ocells[ncell].cell_type == OUTPUT)  || (myorg.ocells[ncell].cell_type == INPUT_OUTPUT))
				{   
				  //myn_readout = myorg.ocells[ncell].cell_n_readout;		  
				  nmolcell = myorg.ocells[ncell].cell_n_molec;  
				  for (nmolecules = 1; nmolecules <= nmolcell; nmolecules++)  
					 if ( (myorg.ocells[ncell].mols[nmolecules].mol_was_activated >= focus) &&   
							(myorg.ocells[ncell].mols[nmolecules].mol_in_readout == TRUE))		  
						{ activatecounter ++;
						  // cout << "cell  " << ncell << ",at "  << nmolecules << " activated #" << myorg.ocells[ncell].mols[nmolecules].mol_was_activated << endl;
						}
				  if  (activatecounter > 0) 
					 {  		  
						strcpy(pres,"1");  
						myorg.ocells[ncell].mols[nmolecules].check =FALSE;
						//	    break;
					 }
				  if (gd.lookat == 2) { //cout << " activatecounter " << activatecounter << endl;
					 cout << " The answer of Output cell # " << ncell << ", is: "<< pres << endl; } 
				  strcat(res,pres);  
				  counter++;
				} 
	  
		  }
      if (counter >= longitud) break;
    }
  strcpy(output_v[nv].data,res);  
  //cout << nv << " ; data=" << output_v[nv].data << ", res= " << res << endl;  
  delete [] pres;  
  delete [] res;  
  if (counter < longitud) error("Not enough readout molecules/output cells to obtain the output");
}  


// Changes molecule structures with a given probability 
// mol_cel == probability of change of that molecule  
// atom_mol == % of molecule that changes  
//   
int change_mol_structure_prob(organism &myorg, global_data gd, CRan32 &rnd)  
{  
  // cout << "Changing molec structures : ";
  int countingmols=0;
  int ncell, nmol = 0; int nummol =0;  
  int fracnatom, natom;  
  long value;  // random number
  int j, mshape_size;  
  mshape_size = gd.shape_size;  
  string newmolecule; newmolecule.reserve(mshape_size);
  string new_r_excit; new_r_excit.reserve(mshape_size); 
  string new_r_inhib; new_r_inhib.reserve(mshape_size); 
  fracnatom = (int)floor(mshape_size * ((float)gd.mutation_rate_atom_mol/100.00));  
  if (fracnatom == 0) 
    error ("No molecule will be mutated, low mutation_rate_atom_mol ");

  for (ncell = 1; ncell<=myorg.ncells; ncell++)  
    { // ncell 
      nummol =  myorg.ocells[ncell].cell_n_molec;		
      for (nmol = 1; nmol <= nummol; nmol++)  
		  {  // nmol
		
			 value = rnd.Next(1,1000000); 	        // choose a random number 
			 if (value <= (gd.mutation_rate_mol_cell*10000.00))   
				{  
				  countingmols++;
				  newmolecule =  myorg.ocells[ncell].mols[nmol].mol_shape;
				  new_r_excit = myorg.ocells[ncell].mols[nmol].r_activation;
				  new_r_inhib = myorg.ocells[ncell].mols[nmol].r_inhibition;
				  // cout << "Change molecule at: " << ncell << "," << nmol << ":" <<  myorg.ocells[ncell].mols[nmol].mol_shape <<"," << myorg.ocells[ncell].mols[nmol].r_activation << "," << myorg.ocells[ncell].mols[nmol].r_inhibition << endl;
				  // cout << "Edf\t" << newmolecule << ", ";
				  for(j=1; j <= fracnatom; j++)  
					 {  
						natom = rnd.Next(0,mshape_size-1);  
						value = rnd.Next(1,99999);  
						if (value > 50000) newmolecule.at(natom) = '0';
						else newmolecule.at(natom) = '1';
					 }  
				  myorg.ocells[ncell].mols[nmol].mol_shape	 =  newmolecule; 
				  for(j=1; j <= fracnatom; j++)  
					 {  
						natom = rnd.Next(0,mshape_size-1);  
						value = rnd.Next(1,99999);  
						if (value > 50000)
						  new_r_excit.at(natom) = '0'; 
						else 
						  new_r_excit.at(natom) = '1';
					 }		  
				  myorg.ocells[ncell].mols[nmol].r_activation	 = new_r_excit;	   
				  if (myorg.ocells[ncell].mols[nmol].flag_inhi == TRUE)  
					 {  
						for(j=1; j <= fracnatom; j++)  
						  {  
							 natom = rnd.Next(0,mshape_size-1);  
							 value = rnd.Next(1,99999);  
							 if (value > 50000)  
								new_r_inhib.at(natom) = '0';
							 else
								new_r_inhib.at(natom) = '1';
						  }
						myorg.ocells[ncell].mols[nmol].r_inhibition	 = new_r_inhib;	
					 } 
				}  
		  }
    }  
  return countingmols;
}  
  
// Function to find the next state in each timestep 

int find_next_state (organism &myorg, int sstep, global_data gd, array_aux a_org[], bool print)
{      
  int nmol, ncell =0;
  int next_cell; 
  int  next_nmol, this_state;      
  int iswork = FALSE;  
  int k, getnmolfromcell;  
  int cuenta = 0; 
  int molcounter = 1;
  int offsetcell = 0;
  // Iterator
  
  vector<long>::iterator iter;

  // updating next states
      
  for (ncell = 1; ncell <= myorg.ncells; ncell++)  
    { // for each cell
      for (nmol = 1; nmol <= myorg.ocells[ncell].cell_n_molec; nmol++) 
		  {  // for each mol
			 this_state = a_org[molcounter].current_state;
			 if (this_state == ACTIVE)
				{   //cout << "\n Cell "<< ncell << ", Active Mol: " << nmol << " molcounter "<<  molcounter << endl; 
				  iswork = TRUE;		 
				  // check for ACTIVATIONS       
				  for(k=0; k < 8; k++)  
					 {  
						getnmolfromcell = a_org[molcounter].activations[k];  
						if (getnmolfromcell > 0) 		    {
						  next_nmol =  getnmolfromcell  % max_n_mol_cell;
						  next_cell =  (int)getnmolfromcell / max_n_mol_cell;
						  getnmolfromcell = myorg.ocells[next_cell].mols[next_nmol].pointer_to_aux;
						  a_org[getnmolfromcell].n_activations++;							 
						}
					 }

				  for(k=0; k< 8; k++)  // check for INHIBITIONS
					 {
						getnmolfromcell = a_org[molcounter].inhibitions[k];		  
						if (getnmolfromcell > 0) 		    {
						  next_nmol =  getnmolfromcell  % max_n_mol_cell;
						  next_cell =  (int)getnmolfromcell / max_n_mol_cell;
						  // cout << " Act Receptor at: " << next_cell << ",mol=" << next_nmol << " ";
						  getnmolfromcell = myorg.ocells[next_cell].mols[next_nmol].pointer_to_aux;
						  a_org[getnmolfromcell].n_inhibitions++; 
						} 
					 }                  
				  //  EFFECTOR - RECEPTOR MOLECULAR INTERACTIONS
				  if ((a_org[molcounter].cell_type != OUTPUT) &&   
						(a_org[molcounter].mol_type == EFFECTOR) )
					 {
						// excitatory 
						k = 0;
						for (iter =a_org[molcounter].cell_cell_activation.begin(); iter != a_org[molcounter].cell_cell_activation.end(); iter++)
						  {							 
							 // getnmolfromcell = a_org[molcounter].cell_cell_activation.at(k);  							
							 getnmolfromcell = *iter;
							 // cout << " Act-- " << getnmolfromcell << endl;		       
							 //getnmolfromcell = a_org[molcounter].cell_cell_activation.at(k);
							 if (getnmolfromcell <= 0) 
								{
								  cout << "molcounter, k, getnmol: " << molcounter << ", " << k << ", " << getnmolfromcell << endl;
								  error(" at cell cell activation, this molecule number should be > 0,", getnmolfromcell);				    
								}		       
							 next_nmol =  getnmolfromcell  % max_n_mol_cell;
							 next_cell =  (int)getnmolfromcell / max_n_mol_cell;
		      
							 getnmolfromcell = myorg.ocells[next_cell].mols[next_nmol].pointer_to_aux;
							 a_org[getnmolfromcell].n_activations++;						
	 
							 // cout << " Act Receptor at: " << next_cell << ",mol=" << next_nmol << " ";
							 //      cout << "Located in aux: " << getnmolfromcell << endl;
							 k = k + 1;
						  }
                      
						// check for inhibitory part
						k = 0;

						for (iter =a_org[molcounter].cell_cell_inhibition.begin(); iter != a_org[molcounter].cell_cell_inhibition.end(); iter++)
						  {							 		      		
							 getnmolfromcell = *iter;		      
							 //getnmolfromcell = a_org[molcounter].cell_cell_inhibition.at(k);  
							 //  cout << " Inh-- " << getnmolfromcell << endl;
							 if (getnmolfromcell <= 0) error(" at cell cell inhibition, this molecule number should be > 0,", k); 
							 next_nmol =  getnmolfromcell  % max_n_mol_cell;
							 next_cell =  (int)getnmolfromcell / max_n_mol_cell;
							 //cout << getnmolfromcell <<" Inh Receptors at: " << next_cell << ",mol=" << next_nmol << " ";
							 getnmolfromcell = myorg.ocells[next_cell].mols[next_nmol].pointer_to_aux;
							 a_org[getnmolfromcell].n_inhibitions++;
							 //cout << "Located in aux: " << getnmolfromcell << endl;
							 k = k + 1;
						  }
					 }  
				} // this active 
			 molcounter = molcounter + 1; 			 
		  } // for each mol of the cell 
      offsetcell = molcounter;  
    } // for each cell 


  molcounter = 1; // for the following loops 
  for (ncell = 1; ncell <= myorg.ncells; ncell++)   
    { // for each cell 
      for (nmol = 1; nmol <= myorg.ocells[ncell].cell_n_molec; nmol++)  
		  {  // for each mol 
			 this_state = a_org[molcounter].current_state;  	  
			 if (this_state == READY)  
				{ 
				  if (a_org[molcounter].n_inhibitions > 0) 
					 { 
						a_org[molcounter].current_state = INACTIVE; 
						a_org[molcounter].t_activations_for_ivector++; 
					 } 
				  else  
					 if (a_org[molcounter].n_activations > 0) { 
						a_org[molcounter].current_state = ACTIVE;  
						a_org[molcounter].t_activations_for_ivector++; 
					 } 
				}  
			 else  
				if (a_org[molcounter].cell_type == RECEPTOR) 
				  a_org[molcounter].current_state= next_state_rec(this_state);	 
				else 
				  a_org[molcounter].current_state= next_state_int(this_state); 


			 // check if activity arrives to the end
	  	  
          if (( (a_org[molcounter].cell_type == OUTPUT) ||
					 (a_org[molcounter].cell_type == INPUT_OUTPUT))
				  &&
				  (a_org[molcounter].mol_type == EFFECTOR) && 
				  (a_org[molcounter].t_activations_for_ivector > 0) )
            {
              cuenta = cuenta + 1;
            }
	  
			 molcounter = molcounter + 1; 
			   
		  }// each mol 
    } // each cell 
				       
 
      
      // checking the state of molecules for activations
      
  if (iswork == FALSE) return 2; // not activity done  
  else   
    if (cuenta >= 1) return 1; // when activity arrived to output cells  
    else   
      return 0;	    
}
 
	  
// Function that allows the spread of activity into the organism, 
// until activations reach effector molecules of output cells, or reach 
// the max of loops, given by the constant "maxiterations". 

void spread_influences_organism(organism &myorg,  global_data &gd, array_aux a_org[])        
{  // loop thorough the array until effectors of output cells are activated   
  int ncell, nmol;  
  int termina = FALSE;  
  int resgo0 = 0;
  int print = FALSE;
  int maxiterations = 20; 
  if (gd.lookat == 2)
    print = TRUE;
  int counter = 0; int molcounter;  
  if (print)
    {
		plot_org_ppm(myorg, gd.c_time, a_org);
	 }
  do   
    { 
      gd.c_time = gd.c_time + 1; 
      if (printdebug == TRUE) 
		  cout << " loop " << counter << " Termina " << termina << endl;
      resgo0 = find_next_state(myorg, gd.c_time, gd, a_org, print);         
      if (print)
		  {
			 plot_org_ppm(myorg, gd.c_time, a_org);
		  }
 
      if (resgo0 == 1) { termina = TRUE; } 
      if (resgo0 == 2) { termina = TRUE;  }
      counter = counter +1 ;
      if (counter > maxiterations) 
		  termina = TRUE;  
    }  
  while (termina!=TRUE);   
 
  // then copy the states into the organism  
  
  molcounter = 1; 
  for (ncell = 1; ncell <= myorg.ncells; ncell++)
    { 
      for (nmol = 1; nmol <= myorg.ocells[ncell].cell_n_molec; nmol++)
		  {  
			 myorg.ocells[ncell].mols[nmol].mol_was_activated = a_org[molcounter].t_activations_for_ivector;	 
			 molcounter = molcounter + 1;
		  }
    }  
}
  

double epoch_pop(organism &myorg, global_data &gd, a_s input_v[],  a_s output_v[], a_s desired_v[], CRan32 &rnd, array_aux a_org[], int typeloop)  
{   
  // cout << "Epoch " <<  gd.actual_iter << endl;
  int nmolchanged=0;
  double myerror = 0.0;  int ncell, nmol, numcells, nummol;
   
  int print = FALSE;
  int i,j;  
  if (gd.lookat == 2)
    print = TRUE;

  gd.counter_mutated_molecules =  nmolchanged;
  for(j=1; j<=gd.n_input_v; j++)   // for every input vector 
    { 
      if (printdebug == TRUE) 
		  cout << " Input Vector " << j << "\t";
      if (print)
		  cout << j << "th input vector: " << input_v[j].data << " Desired Output : " << desired_v[j].data << " Output: ";
      gd.initial_time_vector = gd.c_time;
      gd.current_input_vector = j;
      activate_input_cells_states_with_n(input_v, j, myorg, gd, gd.fraction_input_vector, a_org);  
      spread_influences_organism(myorg, gd, a_org);  
      get_output_vector_or_mode(output_v, j, myorg, gd);  
      if (print) 
	{
	  cout << " Hypernetwork output : " << output_v[j].data << endl;
	  plot_org_ppm(myorg, gd.c_time, a_org); 
	}
      gd.c_time++;
      set_molecules_initial(myorg, a_org);	  
    }
  if (typeloop == TRAIN)
    myerror = evaluate_global_error(input_v, desired_v, output_v, gd.n_input_v, gd.output_string_length, gd);  
  else
    if  (typeloop == TEST)
      myerror = evaluate_global_error_TESTING(input_v, desired_v, output_v, gd.n_input_v, gd.output_string_length, gd);  
  return myerror;  
}  



double epoch(organism &myorg, global_data &gd, a_s input_v[],  a_s output_v[], a_s desired_v[], CRan32 &rnd, array_aux a_org[], int typeloop)  
{   
  // cout << "Epoch " <<  gd.actual_iter << endl;
  int nmolchanged=0;
  double myerror = 0.0;  int ncell, nmol, numcells, nummol;
   
  int print = FALSE;
  int j;  
  if (gd.lookat == 2)
    print = TRUE;
 
  do 
    {
      nmolchanged = change_mol_structure_prob(myorg, gd, rnd);
    } 
  while (nmolchanged == 0); 
  update_cells_num(INPUT, INPUT, myorg,gd);
  update_cells_num(INPUT_OUTPUT, INPUT, myorg,gd);
  fill_relation_array(myorg, gd, a_org);  
  set_molecules_initial(myorg, a_org); 
  gd.counter_mutated_molecules =  nmolchanged;
  for(j=1; j<=gd.n_input_v; j++)   // for every input vector 
    { 
      if (printdebug == TRUE) 
		  cout << " Input Vector " << j << "\t";
      if (print)
		  cout << j << "th input vector: " << input_v[j].data << " Desired Output : " << desired_v[j].data << " Output: ";
      gd.initial_time_vector = gd.c_time;
      gd.current_input_vector = j;
      activate_input_cells_states_with_n(input_v, j, myorg, gd, gd.fraction_input_vector, a_org);  
      spread_influences_organism(myorg, gd, a_org);  
      get_output_vector_or_mode(output_v, j, myorg, gd);  
      if (print) 
		  {
			 cout << " Hypernetwork output : " << output_v[j].data << endl;
			 plot_org_ppm(myorg, gd.c_time, a_org); 
		  }
      gd.c_time++;
      set_molecules_initial(myorg, a_org);	  
    }
  if (typeloop == TRAIN)
    myerror = evaluate_global_error(input_v, desired_v, output_v, gd.n_input_v, gd.output_string_length, gd);  
  else
    if  (typeloop == TEST)
      myerror = evaluate_global_error_TESTING(input_v, desired_v, output_v, gd.n_input_v, gd.output_string_length, gd);
 
  return myerror;  
}  
  
void delete_organism(organism &orig)  
{  
  // clear organism from memory  
  int ncell,numcells;  
  numcells = orig.ncells;  
  for (ncell = 1; ncell <= numcells; ncell++)   
    { 
      orig.ocells[ncell].interaction_cell.clear();
      orig.ocells[ncell].readout.clear();

      delete [] orig.ocells[ncell].mols;            
    } 
  delete [] orig.ocells;  
}  
  
// Split input vector in fractions of n size, then  
// feed eeach cell with that fraction.  
// Receptor molecules of the cell will be activatet  
// It will activate one molecule of each cell, or more than one, if there are not enough input cells.



void activate_input_cells_states_with_n( a_s input_v[], int j_v, organism &myorg, global_data &gd, int nsize,  array_aux a_org[])    
{  

  string orig_str; orig_str.reserve(gd.shape_size);
  string mystring; mystring.reserve(gd.shape_size);
  string molecule; molecule.reserve(gd.shape_size);
  string scrap; scrap.reserve(gd.shape_size); 
  int offset = 0;  
  int inputstringlength=0;  
  inputstringlength= gd.input_string_length;  
  int ncell;  
  int j,  nsubstr, k;  
  int donotcare = 0;
  int cuenta, OK =0;  
  nsubstr = (int)ceil((float)inputstringlength/nsize);  
  offset = 0;   
  orig_str = input_v[j_v].data;
  // cout << inputstringlength << ", Input vector = "<< j_v << "," << orig_str << "," << " Nsubstr" << nsubstr << endl;
  if (orig_str.size() != inputstringlength)
    error("Input string wrong ");
  for (ncell=1; ncell <= myorg.ncells; ncell++)  
    {
      if ((myorg.ocells[ncell].cell_type == INPUT) || (myorg.ocells[ncell].cell_type == INPUT_OUTPUT)) 
		  {		    
	  
			 OK = 0;  
			 mystring = "";
			 mystring = orig_str.substr(offset, nsize);
			 if (mystring.size() < nsize)		       
				{
				  //error("Decrease the 'fraction_input_vector' parameter or the No. of input cells. Input string too short at cell ", ncell);
				  continue;
				}
			 donotcare = 0;
			 for (k=0; k < nsize; k++)
				if (mystring[k] == 'X')
				  {
					 donotcare = 1;
				  }
	  
			 for(j=1; j<=myorg.ocells[ncell].cell_n_molec; j++)  
				{   
				  //strcpy(molecule, myorg.ocells[ncell].mols[j].r_activation.c_str()); 
				  molecule = myorg.ocells[ncell].mols[j].r_activation;
				  scrap = molecule;
				  if ((myorg.ocells[ncell].mols[j].mol_type == RECEPTOR) &&   
						(myorg.ocells[ncell].mols[j].mol_state[0] == READY))
					 if ( (donotcare == 1) || (matching_string(mystring,molecule,nsize) == 0) ) //complete matching  
						{  
						  if (donotcare == 0)
							 {
								myorg.ocells[ncell].mols[j].mol_state[0] = ACTIVE; //  
								a_org[myorg.ocells[ncell].mols[j].pointer_to_aux].current_state = ACTIVE;
								//			cout << offset << ", Activate at Cell " << ncell << " mol= " << j << "is =" << mystring << " r=" <<myorg.ocells[ncell].mols[j].r_activation <<  endl;
							 }
						  OK = 1;       
						  offset = offset + nsize;  		 
						  myorg.ocells[ncell].is_active++;
	 
						  //  cout << offset << ", Activate at Cell " << ncell << " mol= " << j << " " <<myorg.ocells[ncell].mols[j].r_activation          <<  endl;
						  //   cout << "Activation also at aux: " << myorg.ocells[ncell].mols[j].pointer_to_aux << ", doncare=" << donotcare << endl;
						  break;
						}
				}
			 if (OK == 0)  
				{   
				  cout << mystring << ", does not match any receptor on the input cells." << endl;  
				  error("No molecule was activated. Run the update_cells_num function, or increase the No. of receptor molecules in input cell ", ncell);		  
				}  	  
		  }
    }
  if (offset != inputstringlength) 
    { 
      cout << "Using only a substring " << offset << " of the input string of length " <<  inputstringlength << endl;
      error("on input string length." );
    }
  
}


// FOR TRAINING
  
double evaluate_global_error(a_s input_v[], a_s desired_v[], a_s output_v[], int n_input_v, int vec_size, global_data gd)  
{  
  int j;  
  double res = 0.00;  
  int pres = 0;
  for(j=1;j<=n_input_v;j++)    
    {   
      pres = matching_string(desired_v[j].data,output_v[j].data,vec_size);  
      //cout << j << "\t" << input_v[j].data << "\t" << desired_v[j].data << "\t" << output_v[j].data << "\t" << pres << endl;  
      res = res + (double) pres;  
    }  
  res = res/(double)n_input_v; 
  res = res/100;
  // cout << "Learning : " <<1- res << endl;
  return (1-res); // 1- is not for splice  
}    
 

// FOR TESTING: 100 IF COMPLETE MATCHING, 0 FOR ANY PARTIAL MATCHING

double evaluate_global_error_TESTING(a_s input_v[], a_s desired_v[], a_s output_v[], int n_input_v, int vec_size, global_data gd)  
{  
  int j;  
  double res = 0.00;  
  int pres = 0;
  cout << "Vector\t"<< setw(gd.input_string_length+6) << "Input" << "\tDesired\tOutput \tError" << endl;
  cout << "No.   \t"<< setw(gd.input_string_length+6) << "Vector"<< "\tVector \tVector \t     " << endl;
  cout << "------\t"<< setw(gd.input_string_length+6) << "------"<< "\t-------\t-------\t--------" << endl;
 
  for(j=1;j<=n_input_v;j++)    
    {   
      pres = matching_string(desired_v[j].data,output_v[j].data,vec_size);  
      if  (pres == 0) 
		  pres = 0;	
      else 
		  pres = 1;       
      cout << j << "\t" <<  setw(gd.input_string_length+6)  << input_v[j].data << "\t" << desired_v[j].data << "\t" << output_v[j].data << "\t" << pres << endl; 
      res = res + (double) pres;  
    }
   cout << "------\t"<< setw(gd.input_string_length+6) << "------"<< "\t-------\t-------\t--------" << endl;
 
	// cout << "------\t\t------\t\t-------\t\t-------\t\t--------" << endl;
  res = res / (double) n_input_v;
  return (1-res);  
}   
  

 
void just_copy_organism(organism &dest, organism orig)   
{   
  int i, ncell;   
  int numcells;  
  int ROWS, COLS; 
  //  string scrap; // scrap.reserve(max_input_shape_size);
  numcells = orig.ncells;   
  dest.ncells = orig.ncells;   
     
  for (ncell = 1; ncell <= numcells; ncell++)    
    {   
      dest.ocells[ncell].cell_id = orig.ocells[ncell].cell_id;   
      dest.ocells[ncell].cell_n_molec = orig.ocells[ncell].cell_n_molec;   
      dest.ocells[ncell].cell_type = orig.ocells[ncell].cell_type;   
      dest.ocells[ncell].cell_n_r_mol = orig.ocells[ncell].cell_n_r_mol;   
      dest.ocells[ncell].cell_n_e_mol = orig.ocells[ncell].cell_n_e_mol;   
      dest.ocells[ncell].cell_n_i_mol = orig.ocells[ncell].cell_n_i_mol;   
      dest.ocells[ncell].p_inhibitors = orig.ocells[ncell].p_inhibitors;    
      dest.ocells[ncell].cell_n_readout = orig.ocells[ncell].cell_n_readout;   
      dest.ocells[ncell].readout = orig.ocells[ncell].readout; 
      dest.ocells[ncell].x = orig.ocells[ncell].x;   
      dest.ocells[ncell].y = orig.ocells[ncell].y;    
      dest.ocells[ncell].loc_x = orig.ocells[ncell].loc_x;   
      dest.ocells[ncell].loc_y = orig.ocells[ncell].loc_y;   
      dest.ocells[ncell].topology = orig.ocells[ncell].topology;   
      dest.ocells[ncell].threshold_activation = orig.ocells[ncell].threshold_activation;   
      dest.ocells[ncell].threshold_inhibition = orig.ocells[ncell].threshold_inhibition;   
      dest.ocells[ncell].interaction_cell = orig.ocells[ncell].interaction_cell; 
      dest.ocells[ncell].is_active = orig.ocells[ncell].is_active; 
      ROWS = dest.ocells[ncell].x; 
      COLS = dest.ocells[ncell].y; 
      for(i=1; i<=dest.ocells[ncell].cell_n_molec; i++)   
		  {   
			 dest.ocells[ncell].mols[i].mol_id = orig.ocells[ncell].mols[i].mol_id;   

			 dest.ocells[ncell].mols[i].mol_shape = orig.ocells[ncell].mols[i].mol_shape;   
			 dest.ocells[ncell].mols[i].r_activation = orig.ocells[ncell].mols[i].r_activation;   
			 dest.ocells[ncell].mols[i].r_inhibition = orig.ocells[ncell].mols[i].r_inhibition;   
			 /*	  scrap =  dest.ocells[ncell].mols[i].mol_shape;
				scrap =  dest.ocells[ncell].mols[i].r_activation;
				scrap =  dest.ocells[ncell].mols[i].r_inhibition; */
			 dest.ocells[ncell].mols[i].mol_type = orig.ocells[ncell].mols[i].mol_type;   
			 dest.ocells[ncell].mols[i].flag_inhi = orig.ocells[ncell].mols[i].flag_inhi;   
			 dest.ocells[ncell].mols[i].mol_state[0] = orig.ocells[ncell].mols[i].mol_state[0];   
			 dest.ocells[ncell].mols[i].mol_state[1] = orig.ocells[ncell].mols[i].mol_state[1];   
			 dest.ocells[ncell].mols[i].mol_was_activated = 0; // orig.ocells[ncell].mols[i].mol_was_activated;   
			 dest.ocells[ncell].mols[i].loc_x = orig.ocells[ncell].mols[i].loc_x;   
			 dest.ocells[ncell].mols[i].loc_y = orig.ocells[ncell].mols[i].loc_y;   
			 dest.ocells[ncell].mols[i].mol_in_readout = orig.ocells[ncell].mols[i].mol_in_readout;  	    
			 // dest.ocells[ncell].mols[i].cv_activations = orig.ocells[ncell].mols[i].cv_activations;   
			 //dest.ocells[ncell].mols[i].cv_contacts = orig.ocells[ncell].mols[i].cv_contacts;  
			 dest.ocells[ncell].mols[i].pointer_to_aux = orig.ocells[ncell].mols[i].pointer_to_aux;
		  }         
    }   
}     
  


// function to call the random number generator for a number of times
void warming_up_random(CRan32 &myrandom)  
{  
  int i=0; int j;  
  for(i=0; i<=6339; i++)  
    j = myrandom.Next();  
}  
   

void create_copy_organism(organism &dest, organism orig)   
{   
  // first clean memory from &dest.    
  // go for every cell of myorg to create molecules   
  // then with the set of cells   
  // create the new organism   
  int i, ncell;   
  int numcells;   
  int ROWS, COLS; 
  numcells = orig.ncells;   
  dest.ncells = orig.ncells;   
  // cout << "Create-copy: " << dest.ncells << endl;  
  dest.ocells = new cell[numcells+1];  
  for (ncell = 1; ncell <= numcells; ncell++)    
    {   
      cell *newcell;   
      newcell = new cell;   
      newcell->mols = new molecule[orig.ocells[ncell].cell_n_molec+1];   
      newcell->cell_id = orig.ocells[ncell].cell_id;   
      newcell->cell_n_molec = orig.ocells[ncell].cell_n_molec;   
      newcell->cell_type = orig.ocells[ncell].cell_type;   
      newcell->cell_n_r_mol = orig.ocells[ncell].cell_n_r_mol;   
      newcell->cell_n_e_mol = orig.ocells[ncell].cell_n_e_mol;   
      newcell->cell_n_i_mol = orig.ocells[ncell].cell_n_i_mol;   
      newcell->p_inhibitors = orig.ocells[ncell].p_inhibitors;    
      newcell->cell_n_readout = orig.ocells[ncell].cell_n_readout;  		  
      newcell->readout = orig.ocells[ncell].readout; 
      newcell->x = orig.ocells[ncell].x;   
      newcell->y = orig.ocells[ncell].y;    
      newcell->loc_x = orig.ocells[ncell].loc_x;   
      newcell->loc_y = orig.ocells[ncell].loc_y;   
      newcell->topology = orig.ocells[ncell].topology;   
      newcell->threshold_activation = orig.ocells[ncell].threshold_activation;   
      newcell->threshold_inhibition = orig.ocells[ncell].threshold_inhibition;   
      newcell->interaction_cell = orig.ocells[ncell].interaction_cell; 
      newcell->is_active = orig.ocells[ncell].is_active; 
      ROWS = orig.ocells[ncell].x; 
      COLS = orig.ocells[ncell].y; 
      for(i=1; i<=orig.ocells[ncell].cell_n_molec; i++)   
		  {   
			 newcell->mols[i].mol_id = orig.ocells[ncell].mols[i].mol_id;   
			 newcell->mols[i].mol_type = orig.ocells[ncell].mols[i].mol_type; 
			 newcell->mols[i].mol_shape.reserve(orig.ocells[ncell].mols[i].mol_shape.size());
			 newcell->mols[i].mol_shape = orig.ocells[ncell].mols[i].mol_shape;   
			 newcell->mols[i].r_activation.reserve(orig.ocells[ncell].mols[i].r_activation.size());
			 newcell->mols[i].r_activation = orig.ocells[ncell].mols[i].r_activation;   
			 newcell->mols[i].r_inhibition.reserve(orig.ocells[ncell].mols[i].r_inhibition.size());
			 newcell->mols[i].r_inhibition = orig.ocells[ncell].mols[i].r_inhibition;   
	  
			 newcell->mols[i].flag_inhi = orig.ocells[ncell].mols[i].flag_inhi;   
			 newcell->mols[i].mol_state[0] = orig.ocells[ncell].mols[i].mol_state[0];   
			 newcell->mols[i].mol_state[1] = orig.ocells[ncell].mols[i].mol_state[1];   
			 newcell->mols[i].mol_was_activated = orig.ocells[ncell].mols[i].mol_was_activated;   
			 newcell->mols[i].loc_x = orig.ocells[ncell].mols[i].loc_x;   
			 newcell->mols[i].loc_y = orig.ocells[ncell].mols[i].loc_y;   
			 newcell->mols[i].mol_in_readout = orig.ocells[ncell].mols[i].mol_in_readout; 
			 newcell->mols[i].pointer_to_aux = orig.ocells[ncell].mols[i].pointer_to_aux;
			 //     cout << "copy data: " << ncell << "," << i << ":" <<  orig.ocells[ncell].mols[i].mol_shape <<"," << orig.ocells[ncell].mols[i].r_activation << "," << orig.ocells[ncell].mols[i].r_inhibition << endl;
		  }         
      dest.ocells[ncell] = *newcell;   
    }  
  
  
  // cout << "End of copy create " << endl;  
  
}   
 

  
