#include <vector>
#include <string>
#include "constants.h"
using namespace std;

#ifndef H_OBJECTS
#define H_OBJECTS

struct molecule
{
  long mol_id;
  string mol_shape    ; 
  string r_activation ;
  string r_inhibition ;
  int mol_type;       // any type excitatory, inhibitory, null !!!
  int mol_state[2];  // 0, current
  int mol_was_activated; // true, false, or a given number
  int mol_in_readout;   
  int flag_inhi;  // true or false
  int pointer_to_aux;
  int check;
  int loc_x;   // to store graphic location ....
  int loc_y;  //   
}; 

struct cell
{
  long cell_id;  
  int cell_type;
  int cell_n_molec;
  int cell_n_r_mol;   // maximum of 255 molecules for receptors
  int cell_n_i_mol;   // maximum of 255 molecules for intermedaites
  int cell_n_e_mol;
  int cell_n_readout; // number of readouts for cell
  int x, y;   // n of rows, n of columns
  int loc_x, loc_y;       // spatial location
  int topology;
  int p_inhibitors;
  int threshold_activation; //generic threshold for the cell
  int threshold_inhibition; 
  int is_active; 
  int glob_cv_activations, glob_cv_inhibitions;
  molecule *mols;
  vector <long> interaction_cell;
  vector <long> readout;
};
      
struct organism
{
  int ncells;
  cell *ocells;
};


// structure to store topology data
struct topol_data
{
  int dim_topol; 
  int n_row_topol; 
  int dim_topolx; 
  int dim_topoly;
  int nc_i;
  int nc_m;
  int nc_o;
};

// to store global data 
struct global_data 
{
  int   number_of_cells;
  int   total_number_of_molecules;
  int   n_input_v;
  // int   n_readout;
  long  c_time;
  //  long  actual_time;
  long  initial_time_vector;
  int   shape_size;
  int   threshold_activation;
  int   threshold_inhibition;
  float  minimal_global_error;
  int   n_iter;  
  int   actual_iter; 
  int   input_string_length;
  int   output_string_length;
  int   fraction_input_vector;
  float  mutation_rate_mol_cell;
  float   mutation_rate_atom_mol;
  int counter_mutated_molecules;
  int current_input_vector;
  int lookat;
  double g_error_step;
  double g_error;
  long  seed1;
  long seed2;
  int n_try;
};

// array of string - characters
struct a_s
{
  char data[max_input_shape_size];
};

struct loca
{
  int x1;
  int y1;
}; 

struct mol_frequency
{
  unsigned int inmol;
  int accumulado;
  float valor;
};

struct array_aux
{
  long mol_id; // encoded: cell+mol_id
  int cell_type;
  int mol_type;
  int current_state;
  int t_activations_for_ivector;
  int n_activations; // for next state (received in current state)
  int n_inhibitions; //for next state (received in current state)
  int activations[8];  // pointers to neighbooring molecules that can be activated
  int inhibitions[8];  // or inhibited, in the same cell
  // pointer to linked list in case of cell_to_cell interactions
  vector <long> cell_cell_activation; // cell and mol encoded
  vector <long> cell_cell_inhibition; // cell and mol encoded
};

struct moltmp
{
  char mol_shape[max_molecule_domain];
  char r_activation[max_molecule_domain];
  char r_inhibition[max_molecule_domain];
};

void error(const char s[]);
void error(const char s[], const char s2[]);
void error(const char s[], int n);   

void error(string s);
void error(string s1, string s2); 
void error (string s, int n);

void warning(const char* s);
void warning(const char* s, float data);
void warning(const char* s, char *s1);
void warning(char *s);
void warning(string s)   ;
void warning(string s1, string s2) ;
void warning (string s, int n);


#endif
