
/* 
   Hypernetwork testing function 

This program read the organism and 
performs testing evaluation for the input file 

Jose L. Segovia-Juarez, 2004.

*/ 

#include "filemag04.h"  
#include "simfunc04.h"  
#include "cran32.h"  
#include <math.h>  
#include <time.h>  
#include <fstream>
#include <string>

using namespace std;

int main(int argc, char* argv[])   
{  
  // check simulation time    
  time_t initime, fintime;  
  initime = time(NULL);    
   
  // pointers to data vectors   
  a_s *input_v;  
  a_s *output_v;  
  a_s *desired_v;  
  double *error_v;  
  organism org;  
  array_aux *a_org;

  int i,ii,ll,cc;   
  int plot;
  global_data gd;  
  CRan32 rnd(time(NULL),time(NULL)+999); 
  if (argc != 4 ) error("Needed for testing: parameter_file input_file plotting[1=display learning, 2 =Plot organism]");  
       
  gd.actual_iter = 1;  
  read_parameters_file(argv[1], org, gd, rnd);  

  a_org = new array_aux[gd.total_number_of_molecules+1];

  ifstream input_file(argv[2]);
  if (!input_file) error("Cannot find input vector file");
  input_file >> cc;
  input_file.close();
  // cout << cc << "!!" << endl;
  if (cc <= 0) error("Number of input vectors should be greather than zero ");
  gd.n_input_v = cc;

  input_v = new a_s[cc+1];  
  desired_v = new a_s[cc+1];  

  read_input_file(argv[2], input_v, desired_v, gd);  
    
  gd.actual_iter = (int)strtol(argv[3],(char **) NULL,10);
  output_v = new a_s[gd.n_input_v+1];  
  error_v =  new double[gd.n_input_v+1];
 
  plot = (int)strtol(argv[3],(char **) NULL,10);

  gd.lookat = 1;
  if (plot == 2)
     {	
		 gd.lookat = 2;  
		 system("mkdir plotorg");
     }
   
   
  gd.g_error = 0.0;  
  gd.g_error_step = 0.0;
  int j;
  int maxcounter = gd.actual_iter;
  int currentcounter = 1;
  int counterfound = 1;
  cout << "\t\tHypernetwork testing function" << endl << endl;
  //  cout << "\tAuthor: Jose L. Segovia-Juarez, 2001/4." << endl << endl;
  counterfound = read_organism_file(argv, org, gd);
  if (counterfound > 0)
    {
      fill_relation_array(org, gd, a_org);  
      set_molecules_initial(org, a_org);	
      gd.c_time = 1;
      if (plot == 2)
		  cout << "Press Ctrl-Break to end the simulation or Continue. " << endl; 
      for(j=1; j<=gd.n_input_v; j++)   // for every input vector 
	{  
	  if (plot == 2)
	    cout << "Input vector No." << j << ": " << input_v[j].data << ", Desired Output: " << desired_v[j].data << endl; 
	  gd.initial_time_vector = gd.c_time;
	  gd.current_input_vector = j;
	  activate_input_cells_states_with_n(input_v, j, org, gd, gd.fraction_input_vector, a_org); 
	  spread_influences_organism(org, gd, a_org);  	 
	  get_output_vector_or_mode(output_v, j, org, gd); 
	  if (plot == 2) {
	    cout << " Hypernetwork output: " << output_v[j].data << endl;
	    plot_org_ppm(org, gd.c_time, a_org);
	  }
	  gd.c_time++;
	  set_molecules_initial(org, a_org);	  
	}
      gd.g_error = evaluate_global_error(input_v, desired_v, output_v, gd.n_input_v, gd.output_string_length, gd);
      cout << "Training performance evaluated: " << gd.g_error <<   endl; 
      gd.g_error = evaluate_global_error_TESTING(input_v, desired_v, output_v, gd.n_input_v, gd.output_string_length, gd);      
      cout << "Accuracy (#correct entries / #total entries): "<< gd.g_error <<   endl;  
      currentcounter = counterfound+1;
    }
   
  delete [] input_v;  
  delete [] output_v;  
  delete [] desired_v;  
  delete [] error_v;  

  delete_organism(org);  
  
  fintime = time(NULL);   
  int ntime, nhour, nmin, nsec;  
  ntime = (int)difftime(fintime,initime);  
  //	 if (ntime <= 0) ntime = 0;  
  nhour = ntime / 3600;  
  ntime = ntime % 3600;  
  nmin = ntime / 60;  
  ntime = ntime % 60;  
  nsec = ntime;    
  cout << endl << "Author: Jose L. Segovia-Juarez, (c) 2001/4." << endl << endl;
  
  //  cerr << "##Time: " << nhour << "h " << nmin << "m " << nsec << "s." << endl;  

  return 0;     
}  
  
  
     
