#include "constants.h"
#include "objects.h"
#include "cran32.h"

#ifndef FILEMAG_H
#define FILEMAG_H
void save_organism_file_binary(char * argv[], organism myorg, int int_id, global_data dg);
int read_organism_file_binary(char * argv[], organism myorg, int int_id,  global_data gd);

void read_parameters_file(char argv[], organism &morg, global_data &gdata, CRan32 &myrandom );
void read_input_file(char argv[], a_s Minput_v[], a_s Mdesired_v[], global_data &gdata );

void read_test_file(char argv[], a_s test_v[], int &test_string_length,  int &c);

void saving_results_mol(char* argv[], organism myorg, global_data gd);
void saving_global_data(char* argv[], organism myorg, global_data gdata );


void loading_results(char* argv[], cell set_cells[], molecule set_mol[], int step);
void clean_cells(cell set_cells[]);
void clean_molecules_full(molecule set_molecules[]);
void clean_molecules(molecule set_molecules[]);
void copy_set_molecules( molecule dest[], molecule orig[]);
void copy_set_cells(cell dest[], cell orig[]);

void doing_done_file(char * argv[], int h, int m, int s);
 
int read_organism_file(char * argv[], organism myorg, global_data gd );
void save_organism_file(char * argv[], organism myorg, global_data gd );

void check_files(char * argv[]);   

void read_global_file(char * argv[], global_data &gdata);
// void saving_accumulated_mol(char* argv[], organism myorg, global_data gd);
void saving_accumulated_mol_slave(int me, organism myorg, global_data gd);

void read_organism_file_slave( organism myorg);

void saving_results_mol_slave(int me, organism myorg);

void saving_results_mol_step(organism myorg, global_data gd, int state);

void plot_org_ppm(organism &myorg, long time, array_aux a_org[])  ;

int read_organism_file_pop(char * argv[], organism myorg, global_data gd, int npop);
void save_organism_file_pop(char * argv[], organism myorg, global_data gd, int npop);


#endif 

// FILEMAG_H
