// Constants Definitions

#ifndef H_CONSTANTS
#define H_CONSTANTS

const int NMAX_CHILDREN = 60;

const int max_n_cell_org = 500;
const int max_n_mol_cell = 10000;

// Cell Types
const int INPUT =  1;  
const int METAB1 = 2;
const int METAB2 = 3;
const int OUTPUT = 4;
const int INPUT_OUTPUT = 5;

// molecular types 
const int RECEPTOR = 1;
const int EFFECTOR = 3;
const int INTERN   = 2;

// molecular activity types
const int INHIBITORY = 2;
const int NEUTRAL    = 0;
const int EXCITATORY = 1;

// molecular states
const int NULLSTATE = -1; //0
const int READY     = 3;
const int ACTIVE    = 12;
const int INACTIVE  = 0;   // or resting state //3
const int DELAY1    = 2;   // one step for receptor activity
const int DELAY2    = 3;   // can be more than one step
const int WRONG_STATE = 99;
// 
const int max_input_shape_size = 512; // just for the input vector
const int max_molecule_domain = 50; // this is 2^16 molecules

const int TRUE = 1;
const int FALSE = 0;

const int TRAIN = 10;
const int TEST = 11;

const int NCOLS_ORG = 24; // 
const int topology_rectangle = 1;
const int topology_hexagonal = 2;

typedef int Etype;

#endif

